#ifndef PLAYER_H
#define PLAYER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"

#define GRAVITY 4

/** Player Class
 * @brief Class to control the player
 * @author Joe Barhouch
 * @author 201291584
 */


class Player
{
public:
    /** Constructor */
    Player();
    /** Deconstructor */
    ~Player();
    /** initialise the player
    *@param inital X position
    *@param inital Y position
    */
    void init(int x, int y);
    /** Draw on the lcd
    *@param lcd
    */
    void draw(N5110 &lcd);
    /** Update inputs
    *@param Direction d of the Joystick
    *@param Magnitude of joystick position
    *@param Y position of platforms
    *@param fall true if the player is falling
    *@param jump is true f player is jumping
    */
    void update(Direction d, float mag, int Ypos, bool fall, bool jump);
    /** set position of enemies
    *@return Vector2D of the position
    */
    Vector2D get_pos();



private:
    int _vx;
    int _vy;
    int _playerX;
    int _playerY;
    bool _floorCollision;
    char _dir;
    Timer t;
    bool f;

};

#endif