#include "Enemy.h"
#include "EnemySprites.h"
//constructor
Enemy::Enemy(bool type, int spawnX, int spawnY)
{
    _enY = spawnY;
    _enX = spawnX;

    if( spawnX > WIDTH/2) {
        xDir = 1; //right
    } else {
        xDir = 0; //left
    }

    if ( spawnY > HEIGHT/2) {
        yDir = 1; //up
    } else {
        yDir = 0; //down
    }
    _type = type;

}

//deconstructor
Enemy::~Enemy() {}


//update
void Enemy::update(int _ev)
{

    if( _type == TYPE_HOR ) {
        // go left or right depending on direction
        switch (xDir) {
            case 1:
                _enX -= _ev;
                //switch direction when it hits a wall
                if(_enX + 7 > WIDTH || _enX < 0) {
                    xDir = 0;
                    break;
                }
                break;
            case 0:
                _enX += _ev;
                //switch direction when it hits a wall
                if(_enX + 7 > WIDTH || _enX < 0) {
                    xDir = 1;
                    break;
                }
                break;
        }
    }

    if( _type == TYPE_VERT ) {
// go up or down depending on direction
        switch (yDir) {
            case 1:
                _enY -= _ev;
                //switch direction when it hits a wall
                if(_enY + 5 > HEIGHT || _enY < 0) {
                    yDir = 0;
                    break;
                }
                break;
            case 0:
                _enY += _ev;
                //switch direction when it hits a wall
                if(_enY + 5 > HEIGHT || _enY < 0) {
                    yDir = 1;
                    break;
                }
                break;
        }
    }
}



//draw
void Enemy::draw(N5110 &lcd)
{
    switch(_type) {
        case 1: // vertical
            drawVertical(lcd);
            break;
        case 0: // horizontal
            drawHoriz(lcd);
            break;
    }
}

// sub draw
void Enemy::drawVertical(N5110 &lcd)
{
    if (yDir == 0 ) {
        Bitmap vertDown(s_enemy2_inv, 5, 7);
        vertDown.render(lcd, _enX, _enY);
    } else {
        Bitmap vertUp(s_enemy2, 5, 7);
        vertUp.render(lcd, _enX, _enY);

    }

}

// sub draw
void Enemy::drawHoriz(N5110 &lcd)
{
    if (xDir == 1) {
        Bitmap horLeft(s_enemy1_inv, 5, 7);
        horLeft.render(lcd, _enX, _enY);
    } else {
        Bitmap horRight(s_enemy1, 5, 7);
        horRight.render(lcd, _enX, _enY);

    }

}

//mutator
void Enemy::set_pos(int x, int y)
{
    _enX = x;
    _enY = y;

}


//accessor
Vector2D Enemy::get_pos()
{
    Vector2D pos = {_enX, _enY};
    return pos;
}
