#ifndef ENGINE_H
#define ENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Player.h"
#include "Platform.h"
#include "Enemy.h"
#include "Coin.h"
#include <vector>
/** Draws the Map */
void drawMap(N5110 &lcd);

/** Player Class
 * @brief Class to control the whole game
 * @author Joe Barhouch
 * @author 201291584
 */

class Engine
{

public:
    /** Constructor */
    Engine();
    /** Deonstructor */
    ~Engine();
    /** Initialisation of all parameters */
    void init();
    /** Reads gamepad
    *@param pad
    */
    void read_input(Gamepad &pad);
    /** update physics
     *@param pad
    */
    void update(Gamepad &pad);
    /** Draw on the lcd
    *@param lcd
    */
    void draw(N5110 &lcd);
    /** Computes collision with platforms of the map*/
    void floorCollide();
    /** spawn new enemy with time passed*/
    void spawnEnemy();
    /** Computes collision with enemies
    *@return returns true if player hits enemy
    */
    bool enemyCollide();
    /** Computes player falling down
    *@return returns true if player falls off the screen
    */
    bool fellDown();
    /** Computes dying conditions
    *@return returns true if player falls off the screen or hits an enemy
    */
    bool koed();
    /** Dying animations*/
    void gameOver(N5110 &lcd);
    /** Computes if coins are taken*/
    void coinTaken(Gamepad &pad);
    /** Computes final score
    *@return returns final score
    */
    int getScore();
     
     
    vector <int> middlesX;
    vector  <int> middlesY;
    //counter 
    int counter;
private:

    //player object
    Player _p;
    // player coordinates
    int _px;
    int _py;

    Vector2D player;

    // coin object
    Coin coin;
    Vector2D coinPos;
    int f;
    int score;

    
    //gamepad
    Direction _d;
    float _mag;

    //physics
    bool _jump;
    int _Ypos;
    bool _fall;
    bool _c;

    //enemy
    vector <Enemy> enemies;
    

    //deaths
    bool ko1;
    bool ko2;

    //time 
    Timer t;
    

    

};

#endif