/** Tooling library
 * @brief Library of commonly used functions across the game
 * @author George Sykes [el18gs]
 * @date 12 May 2020
 * @version 0.2
 */
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"
#include "SDFileSystem.h"

/** @pulic vector of strings used in data processing
*/
typedef std::vector<std::string> stringvec;

/** Function to check if one string ends with another
* @param fullString the string that might end in the other
* @param ending the string that might be the others ending
* @return bool true if 'fullstring' ends with 'ending'
* @note from https://stackoverflow.com/a/874160
*/
bool hasEnding (std::string const &fullString, std::string const &ending);

/** List all files in the directory path passed
* @param Path directory to list
* @param sd Pointer to an SDFileSystem object
*/
void listdir(std::string path, SDFileSystem &sd);

/** Import a .sprite file from the sd card and convert it too a 2d array
* @param file the path of the file too import
* @param sd pointer to an SDFileSystem object
* @return int** a 2d array of the same size as the file imported
*/
int** import_sprite(std::string file, SDFileSystem &sd);

/** map a value between two ranges AKA, (1 to 0) -> (2 to 0)
* @param OldMax the maximum input value
* @param OldMin the minimum input value
* @param NewMax the maximum output value
* @param NewMin the minimum output value
* @param OldValue input value
* @return float bounded by the NewMax and NewMin
* @note from https://stackoverflow.com/a/929107
*/
float cursor_transform(float OldMax,
                       float OldMin,
                       float NewMax,
                       float NewMin,
                       float OldValue);