#include "tooling.h"

// Function taken from https://stackoverflow.com/a/874160/10436605
bool hasEnding (std::string const &fullString, std::string const &ending)
{
    if (fullString.length() >= ending.length()) {
        return (0 == fullString.compare (fullString.length() - ending.length(), ending.length(), ending));
    } else {
        return false;
    }
}

void listdir(std::string path, SDFileSystem &sd)
{
    printf("Listing directory: %s\n", path.c_str());
    DIR *d;
    struct dirent *p;

    d = opendir(path.c_str());
    if (d != NULL) {
        while ((p = readdir(d)) != NULL) {
            printf(" - %s\n", p->d_name);
        }
    } else {
        printf("Could not open directory!\n");
    }
    closedir(d);
}

int** import_sprite(std::string file, SDFileSystem &sd)
{
    FILE *fp; // this is our file pointer

    // the previous example just read the values into variables and printed to
    // serial, we'll now read files into an array.

    // now open file for reading...note the 'r'
    fp = fopen(file.c_str(), "r");


    int n=0;  // going to store the number of lines in the file
    stringvec values;

    if (fp == NULL) {  // if it can't open the file then print error message
        printf("Error! Unable to open file: %s\n", file.c_str());
        listdir("/sd/assets", sd);
    } else {
        //Since we may not know the
        // number of lines in the files ahead of time, we'll first count them
        // * means scan but don't save
        int max_len_tmp = 0;
        int max_len = 0;

        while (fscanf(fp, "%*i%n", &max_len_tmp) != EOF) {
            n++;  // increment counter when read a line
            if(max_len_tmp > max_len) {
                max_len = max_len_tmp;
            }
        }

        max_len--;

        rewind(fp); // 'scrolled' to end of file, so go back to beginning

        char buffer[n][max_len];

        for(int i = 0; i < n; i++) {
            fscanf(fp, "%s", &buffer[i][0]);
        }

        int** sprite = 0;
        sprite = new int*[n];
        for(int i = 0; i < n; i++) {
            sprite[i] = new int[max_len];
        }

        for(int i = 0; i < n; i++) {
            //printf("%s\n", buffer[i]);
            for(int j = 0; j < max_len; j++) {
                if((int)buffer[i][j] == 48) {
                    sprite[i][j] = 0;
                } else if((int) buffer[i][j] == 49) {
                    sprite[i][j] = 1;
                }
            }
        }

        fclose(fp);  // ensure you close the file after reading

        return sprite;

    }

    return 0;
}

float cursor_transform(float OldMax,
                       float OldMin,
                       float NewMax,
                       float NewMin,
                       float OldValue)
{
    float NewValue = -1;
    float OldRange = (OldMax - OldMin);
    if (OldRange == 0) {
        NewValue = NewMin;
    } else {
        float NewRange = (NewMax - NewMin);
        NewValue = (((OldValue - OldMin) * NewRange) / OldRange) + NewMin;
    }
    return NewValue;
}
