/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20
Name: George Sykes
Username: el18gs
Student ID Number: 201235346
Date: 08/02/2020 
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SDFileSystem.h"
#include "gameEngine.h"
#include "FX0S8700CQ.h"
#include "Ghost.h"
#include "Inventory.h"
#include "tooling.h"
#include <vector>
#include <string>

// objects
Gamepad pad;
N5110 lcd;
FX0S8700CQ accel;
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS

// Declare all the inputs
InterruptIn buttonX(PTC5);
InterruptIn buttonA(PTC7);
InterruptIn buttonB(PTC9);
InterruptIn buttonY(PTC0);
InterruptIn buttonStart(PTC8);

// Declare output
// RED, YELLOW, GREEN
BusOut left_LED(PTC3,PTC2,PTA2);
BusOut right_LED(PTC11,PTC10,PTA1);

// Function prototypes
void setupISR();
void zeroFlags();

// Settings variables
volatile int g_button_sesnsitivity = 250;
volatile bool g_buttonTesting = false;
volatile int g_buttonSensitivityTest = 250;


// ISR functions
void buttonX_isr();
void buttonA_isr();
void buttonB_isr();
void buttonY_isr();
void buttonStart_isr();

// ISR flags
volatile int g_buttonX_flag = 0;
volatile int g_buttonA_flag = 0;
volatile int g_buttonB_flag = 0;
volatile int g_buttonY_flag = 0;
volatile int g_buttonStart_flag = 0;

int main()
{
    gameEngine game(sd, pad, lcd);
    setupISR(); // Hook all the ISR to their buttons
    srand(time(NULL)); // Set the sed to millisecconds from start
    Inventory inventory(sd);

    game.welcome(sd, lcd, pad, g_buttonA_flag); // Display the welcome screen

    while(1) {
        int choice = game.game_menu(lcd, g_buttonA_flag, g_buttonB_flag, g_buttonX_flag); // Display the game menu
        switch (choice) {
            case 0:
                game.catch_ghosts(inventory, accel, sd, lcd, pad, g_buttonA_flag, left_LED, right_LED);
                break;
            case 1:
                inventory.display_inventory(sd, lcd, pad, g_buttonX_flag, g_buttonStart_flag, g_buttonA_flag);
                break;
            case 2:
                game.settings(lcd, pad, g_buttonA_flag, g_buttonStart_flag, g_buttonX_flag, g_buttonB_flag, g_buttonTesting, g_buttonSensitivityTest, g_button_sesnsitivity);
                break;
        }
    }
}

void setupISR()
{
#ifdef DEBUG
    printf("Initialising ISR\n");
#endif
    buttonX.mode(PullUp); // turn on internal pull-up resistor
    buttonX.fall(&buttonX_isr);
    buttonA.mode(PullUp); // turn on internal pull-up resistor
    buttonA.fall(&buttonA_isr);
    buttonB.mode(PullUp); // turn on internal pull-up resistor
    buttonB.fall(&buttonB_isr);
    buttonY.mode(PullUp); // turn on internal pull-up resistor
    buttonY.fall(&buttonY_isr);
    buttonStart.mode(PullUp); // turn on internal pull-up resistor
    buttonStart.fall(&buttonStart_isr);
}

void zeroFlags()
{
    g_buttonX_flag = 0;
    g_buttonA_flag = 0;
    g_buttonB_flag = 0;
    g_buttonY_flag = 0;
    g_buttonStart_flag = 0;
}

// Button A event-triggered interrupt
void buttonX_isr()
{
    g_buttonX_flag = 1;   // set flag in ISR
    if(!g_buttonTesting) {                  // Check if the button sensitivity is being tested
        wait_ms(g_button_sesnsitivity);
    } else {
        wait_ms(g_buttonSensitivityTest);
    }
}

// Button A event-triggered interrupt
void buttonA_isr()
{
    g_buttonA_flag = 1;   // set flag in ISR
    wait_ms(g_button_sesnsitivity);
}

// Button A event-triggered interrupt
void buttonB_isr()
{
    g_buttonB_flag = 1;   // set flag in ISR
    wait_ms(g_button_sesnsitivity);
}

// Button A event-triggered interrupt
void buttonY_isr()
{
    g_buttonY_flag = 1;   // set flag in ISR
    wait_ms(g_button_sesnsitivity);
}

// Button A event-triggered interrupt
void buttonStart_isr()
{
    g_buttonStart_flag = 1;   // set flag in ISR
    wait_ms(g_button_sesnsitivity);
}