/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Alessandro Carboni
Username: el18ac
Student ID Number: 201253364
Date: 10/03/2020
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include <vector>
#include "Menu.h"
#include "Game.h"

//objects
N5110 lcd;
Gamepad pad;
Menu menu(lcd,pad);


//functions
void init();
void game_function();

//variables
int g_check = 0;


int main()
{
    //initialises the lcd and the gamepad
    init();
    lcd.clear();
    //creates the initial screen
    menu.initscreen();
    //infinite loop for the game and menu
    while(1) {
        //checks if the gameover function is returning new game or menu
        if (g_check == 2 || g_check == 0) {
            menu.menu_screen();
            game_function();
        } else if ( g_check == 1) {
            game_function();
        }
    }
}
void init()
{
    lcd.init();//initialises the screen
    pad.init();//initialises the gamepad
}

void game_function()
{
    //creates class objects
    Game game;
    game.movement(pad);
    game.draw(lcd, pad);
    while(1) {
        lcd.clear();
        //printf("clear\n");
        game.movement(pad);
        //printf("movement\n");
        game.updating_position();
        //printf("updating_position");
        game.draw(lcd, pad);
        //printf("draw\n");
        /*this part is executed if you die, and
        chose to return to the main menu*/
        if (game.death(lcd, pad) == 2) {
            g_check = 2;
            break;
            /*this part is executed if you die, and
            chose to play again*/
        } else if (game.death(lcd, pad) == 1) {
            g_check = 1;
            break;
        }
        //printf("death\n");
        game.point(lcd, pad);
        //printf("point\n");
        lcd.refresh();
        /*based on the value of the potentiometer
        the refresh rate can be increased and
        by doing so you can increase the speed*/
        for(int i = 0; i < pad.read_pot2()*50; i++) {
            wait(0.01);
            game.movement(pad);
        }
    }
}

