#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

/** Menu Class
* @brief controls the home page, the menu and the help function
* @author Alessandro Carboni
* @date Apr, 2020
*/

class Menu
{

private:
    //classes
    N5110 _lcd;
    Gamepad _pad;

public:
    //functions
    
    /**Constructor
    *@param N5110 object
    *@param Gamepad object
    */
    Menu(N5110 &lcd,Gamepad &pad);

    /**Make initial screen
    */
    void initscreen();
    
    /**Make the menu screen
    */
    void menu_screen();
    
    /**Make the arrow in the menu
    */
    void arrow();
    
    /**Make the help function
    */
    void help();
};

#endif