#include "Menu.h"
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

//design of snake on initial page
int snake[28][26] {
    { 0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0 },
    { 0,0,0,0,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1 },
    { 0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1 },
    { 0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1 },
    { 0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,1 },
    { 0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1 },
    { 0,1,0,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,0,0,1,0 },
    { 1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0 },
    { 1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0 },
    { 1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0 },
    { 1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0 },
    { 0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0 },
    { 0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0 },
};

//design of skull in the help page
int skull[23][23] {
    { 0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0 },
    { 1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1 },
    { 1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1 },
    { 1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1 },
    { 0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0 },
    { 0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,1,1,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,1,1,1,1,0,0,0,1,1,1,1,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,1,1,1,1,0,0,0,1,1,1,1,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,1,1,0,0,1,0,0,1,1,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0 },
    { 0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0 },
    { 0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0 },
    { 1,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,0,0,1,1,1 },
    { 1,0,0,0,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,0,0,0,1 },
    { 1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,0,0,0,1,0,0,1,1 },
    { 0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0 },
    { 0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
};

//design of the arrow in the menu function
int selector[5][7] {
    { 0,0,0,0,1,0,0 },
    { 0,0,0,0,1,1,0 },
    { 1,1,1,1,1,1,1 },
    { 0,0,0,0,1,1,0 },
    { 0,0,0,0,1,0,0 },
};

//initialising the gamepad and the screen
Menu::Menu(N5110 &lcd,Gamepad &pad)
{
    _lcd = lcd;
    _pad = pad;
};

void Menu::initscreen()
{
    while( _pad.start_held() == false) {
        //initial page
        _lcd.clear();
        _lcd.drawSprite(29,1,28,26,(int*)snake);
        _lcd.printString("SNAKE",WIDTH/2-15,4);
        _lcd.printString("Press Start",WIDTH/2-30,5);
        _lcd.setContrast( _pad.read_pot1());
        _lcd.refresh();
        wait(0.2);
    }
    _lcd.clear();
}

void Menu::menu_screen()
{
    wait(0.1);
    _lcd.drawSprite(WIDTH/2-26,25,5,7,(int*)selector);
    _lcd.refresh();
    while(_pad.A_held() == false) {
        /*unitl A is pressed, the code
        stays on the menu,
        executing only the code of the arrow*/
        arrow();
        _lcd.refresh();
        wait(0.2);
    }

    /*if A is pressed and the arrow
    is corresponding to HELP,
    the code executes help function*/
    if (_lcd.getPixel(20,35)) {
        help();
        _lcd.refresh();
        wait(0.2);
    }
}

void Menu::arrow()
{
    //main menu design
    _lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    _lcd.printString("MENU",WIDTH/2-15,1);
    _lcd.printString("Play",WIDTH/2-13,3);
    _lcd.printString("Help",WIDTH/2-13,4);
    _lcd.refresh();
    wait(0.2);

    /*position of arrow in the meun
    according to what button is pressed*/
    if ( _pad.X_held() == true) {
        _lcd.clear();
        _lcd.drawSprite(WIDTH/2-26,25,5,7,(int*)selector);
        _lcd.refresh();
        wait(0.2);
    }

    /*position of arrow in the meun
    position of arrow in the meun
    according to what button is pressed*/
    if ( _pad.B_held() == true) {
        _lcd.clear();
        _lcd.drawSprite(WIDTH/2-26,33,5,7,(int*)selector);
        _lcd.refresh();
        wait(0.2);
    }
}

void Menu::help()
{
    while(1) {
        //help instructions, page 1
        _lcd.clear();
        _lcd.printString("Use the",21,0);
        _lcd.printString("buttons",21,1);
        _lcd.printString("to move",21,2);
        _lcd.printString("(press B)",15,5);
        _lcd.refresh();
        wait(0.2);
        if (_pad.B_held()) {
            //if B is pressed, go to next page
            break;
        }
    }
    wait(0.2);

    while(1) {
        //help instructions, page 2
        _lcd.clear();
        _lcd.printString("Use the",21,0);
        _lcd.printString("potentiometer",3,1);
        _lcd.printString("to control",13,2);
        _lcd.printString("the speed",17,3);
        _lcd.printString("(press B)",15,5);
        _lcd.refresh();
        wait(0.2);

        if (_pad.B_held()) {
            //if B is pressed, go to next page
            break;
        }
    }
    wait(0.2);

    while(1) {
        //help instructions, page 3
        _lcd.clear();                                        
        _lcd.printString("Eat the fruit",5,0);
        _lcd.printString("to score",15,1);
        _lcd.printString("(press B)",16,5);
        _lcd.refresh();
        wait(0.2);

        if (_pad.B_held()) {
            //if B is pressed, go to next page
            break;
        }
    }
    wait(0.2);

    while(1) {
        //help instructions, page 4
        _lcd.clear();                                        
        _lcd.printString("If you hit",13,0);
        _lcd.printString("a wall",23,1);
        _lcd.printString("or your tail",5,2);
        _lcd.printString("...",WIDTH/2-7,3);
        _lcd.printString("(press B)",16,5);
        _lcd.refresh();
        wait(0.2);

        if (_pad.B_held()) {
            //if B is pressed, go to next page
            break;
        }
    }
    wait(0.2);

    while(1) {
        //help instructions, final page
        _lcd.clear();                                        
        _lcd.printString("YOU DIE!",20,1);
        _lcd.drawSprite(30,16,23,23,(int*)skull);
        _lcd.refresh();
        wait(0.2);

        if (_pad.B_held()) {
            //if B is pressed, go back to the menu
            break;
        }
    }
    wait(0.2);
    //after help instructions, returns to main menu
    _lcd.clear();
    menu_screen();                                           
    _lcd.refresh();
    wait(0.2);
}