#ifndef GAME_H
#define GAME_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include <vector>
#include "Menu.h"

/** Game Class
* @brief controls the functioning of the game
* @author Alessandro Carboni
* @date Apr, 2020
*/

class Game
{

private:

    int x;
    int y;
    int fruitX [16];
    int fruitY [9];
    int score;
    int a;       //used to select the direction based ont what button is pressed
    int ntail;   //used to increase lenght of the tail
    int k;
    int rx;
    int ry;
    char buffer[10];
    int fruitX1;
    int fruitY1;
    vector <int> x_pos;
    vector <int> y_pos;

public:
    /**Constructor*/
    Game();//initialises the game

    /**Reguates the diretion of movement of the snake
    * @param Gamepad class object
    */
    void movement(Gamepad &pad);
    
    /**Regulates the way the snake moves
    */
    void updating_position();
    
    /**Get value of which button is pressed
    *@ param N5110 class object
    *@ param Gamepad class object
    * @return death value (0,1,2)
    */
    int death(N5110 &lcd,Gamepad &pad);
    
    /**Draws the game field, the snake and the fruit
    *@ param N5110 class object
    *@ param Gamepad class object    
    */
    void draw(N5110 &lcd,Gamepad &pad);
    
    /**Executes what happens when you die
    *@ param N5110 class object
    *@ param Gamepad class object  
    */
    void gameover(N5110 &lcd,Gamepad &pad);
    
    /**Increases your points and your lenght when you score
    *@ param N5110 class object
    *@ param Gamepad class object  
    */
    void point(N5110 &lcd,Gamepad &pad);
};

#endif