#include "Game.h"
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Menu.h"

//initialise the game
Game::Game()
{
    x = 4; //sets initial x position to 4
    y = 4; //sets initial y position to 4
    /*creates the array for the possible x coordinates the fruit can have
    in order to be always alligned with the snake and stay inside the field*/
    for (int i = 0; i < 16; i++) { 
        fruitX[i] = 3 + i*5;       
    }
    /*creates the array for the possible y coordinates the fruit can have
    in order to be always alligned with the snake and stay inside the field*/
    for (int i = 0; i < 9; i++) {       
        fruitY[i] = 3 + i*5;            
    }
    score = 0; //initial score is 0
    a = 0; //used to select the direction based ont what button is pressed
    ntail = 0; //used to increase lenght of the tail, initially set to 0
    k = 0;
    rx = rand() % 16; //choses a random number between 1 and 16, assigning it to the corresponding value in the for loop (x axis)
    ry = rand() % 9;  //same as the previous line but between 1 and 9 for the y axis
    fruitX1 = fruitX[rx]+1; //this line and the following calculate the center
    fruitY1 = fruitY[ry]+1; // point of the fruit needed to register the overlap with the head
    x_pos.push_back(4); //adds initial x coordinate to the movement vector
    y_pos.push_back(4); //adds initial y coordinate to the movement vector
}

void Game::movement(Gamepad &pad)
{
    /*registers what button is being pressed,
    associating it to an integer value
    between 1 and 4
    the second condition in each loop
    is needed to prevent the snake from
    going backwards on itself*/
    if (pad.Y_held() && !(a == 2)) {    
        a = 1;                          
    }                                   
    if (pad.A_held() && !(a == 1)) {    
        a = 2;                          
    }                                   
    if (pad.X_held() && !(a == 4)) {
        a = 3;
    }
    if (pad.B_held() && !(a == 3)) {
        a = 4;
    }
}

void Game::updating_position()
{
    /*reads the integer value stored in the prevoius function
    and depending on its value decides which way the snake moves*/
    if (a == 1) {    
        x += -5; //left
    }
    if (a == 2) {
        x += 5; //right
    }
    if (a == 3) {
        y += -5; //up
    }
    if (a == 4) {
        y += 5; //down
    }

    int prevX = x_pos[0];
    int prevY = y_pos[0];

    x_pos[0] = x;
    y_pos[0] = y;

    /*adds each new segment's coordinates to the
    movement vector in order to give each
    section the same movement*/
    if (!(ntail + 1 == x_pos.size())) {             
        x_pos.push_back(x_pos[ntail - 1]);          
        y_pos.push_back(y_pos[ntail - 1]);          
    }

    if (x_pos.size() > 0) {
        /*regulates the movement of the snake
        having each section move to the previous
        coordinates of the segment in front of it*/
        for (int i = 0; i < x_pos.size() - 1; i++) {                        
            x_pos[x_pos.size() - i - 1] = x_pos[x_pos.size() - i - 2];      
            y_pos[y_pos.size() - i - 1] = y_pos[y_pos.size() - i - 2];      
        }
        x_pos[1] = prevX;
        y_pos[1] = prevY;
    }
}

int Game::death(N5110 &lcd,Gamepad &pad)
{
    //if you hit the side walls you die
    if (x < 1 || x > WIDTH-2) { 
        while (1) {
            gameover(lcd, pad);
            if (pad.B_held()) {
                //if you press start you will go back to the menu
                return 1;
            }
            if (pad.start_held()) {
                //if you press B, you will initiate a new game
                return 2;
            }
        }
    }
    
    //if you hit the top or bottom walls you die
    if (y < 1 || y > HEIGHT) {
        while (1) {
            gameover(lcd, pad);
            if (pad.B_held()) {
                return 1;
            }
            if (pad.start_held()) {
                return 2;
            }
        }
    }
    //if you hit any part of your tail you die
    for (int i = 1; i < x_pos.size(); i++) {
        if (x_pos[0] == x_pos[i] && y_pos[0] == y_pos[i]) {
            while (1) {
                gameover(lcd, pad);
                if (pad.B_held()) {
                    return 1;
                }
                if (pad.start_held()) {
                    return 2;
                }
            }
        }
    }
    return 0; //if 0 is returned, there is no gamover and the game goes on 
}

void Game::draw(N5110 &lcd,Gamepad &pad)
{
    lcd.clear();
    lcd.drawRect(1,1,WIDTH-2,HEIGHT-1,FILL_TRANSPARENT); //rectangle around border of field
    lcd.drawRect(fruitX[rx],fruitY[ry],3,3,FILL_BLACK); //fruit on the field
    lcd.drawCircle(x,y,2,FILL_TRANSPARENT); //initial snake design
    //printf("size of vector %d\n", x_pos.size());
    for (k = 1; k <= ntail; k++) {
        lcd.drawCircle(x_pos[k],y_pos[k],2,FILL_TRANSPARENT); //draws each new segment of the snake
        //printf("draw \n");
    }
    lcd.refresh();
    //printf("Fruit x coordinate: %d\n", fruitX1);
    //printf("Fruit y coordinate: %d\n", fruitY1);
    //printf("Snake x: %d\n", x);
    //printf("Snake y: %d\n", y);
    //printf("seg1 x: %d\n", x_pos[1]);
    //printf("seg1 y: %d\n", y_pos[1]);
}

void Game::gameover(N5110 &lcd,Gamepad &pad)
{
    //display of the gameover screen
    lcd.clear();
    lcd.printString("GAME OVER",WIDTH/2-25,0);          
    sprintf (buffer, "Score: %d",score);
    lcd.printString(buffer,WIDTH/2-26,2); //displays your score
    lcd.printString("Play Again: B",0,4); //if you want to play again press B
    lcd.printString("Menu: Start",0,5); //if you want to access the main menu press start
    pad.leds_on();
    wait(0.1);
    pad.leds_off();
    wait(0.1);
    pad.tone(500.0,1);
    lcd.refresh();
    wait(1/6);
}

void Game::point(N5110 &lcd,Gamepad &pad)
{
    /*if central coordinate of the snake head 
    is equal to the central coordinate of the food:*/
    if (x == fruitX1 && y == fruitY1) {
        //printf("Snake x: %d\n", x);
        //printf("Snake y: %d\n", y);
        //printf("seg1 x: %d\n", x_pos[1]);
        //printf("seg1 y: %d\n", y_pos[1]);
        //printf("Fruit x coordinate: %d\n", fruitX1);
        //printf("Fruit y coordinate: %d\n", fruitY1);
        score = score + 10; //adds 10 to the score each time you eat a fruit
        pad.tone(750.0,1);
        rx = rand() % 16; //generates a new random x coordinate for the food
        ry = rand() % 9; //generates a new random x coordinate for the food
        //printf("rx: %d\n", rx);
        //printf("ry: %d\n", ry);
        fruitX1 = fruitX[rx]+1;
        fruitY1 = fruitY[ry]+1;
        for (int i = 0; i < x_pos.size(); i++) {
            /*if the random set of coordinates
            corresponds to the position of one of 
            the segments of the snake it finds
            a new set of coordinates*/
            if (fruitX1 == x_pos[i] && fruitY1 == y_pos[i]) {       
                rx = rand() % 16;                                   
                ry = rand() % 9;                                    
                fruitX1 = fruitX[rx]+1;
                fruitY1 = fruitY[ry]+1;
            }
        }
        ntail++; //increases the lenght of the tail
        lcd.drawRect(fruitX[rx],fruitY[ry],3,3,FILL_BLACK); //draws the new fruit
    }
}