/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:Samuel Lashmar
Username:el17sdl
Student ID Number:201170334
Date:04/03/20
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SnakeHead.h"
#include "SnakeTail.h"
#include "GameEngine.h"


// objects
Gamepad pad;
N5110 lcd;
SnakeHead head;
SnakeTail tail;
GameEngine engine;

//
#define HEAD_SIZE 1
#define HEAD_SPEED 3


void welcome();
void init();
void render();


int main()
{
    //set frames per second 
    int fps = 4;
    //initialise objects 
    init();
    //display simple start screen and wai for user to press start
    welcome();
    //clear lcd and render first frame 
    render();
    //while one loop so keep keeps running   
    while(1) {
    /* Debugging print statements to ensure gamepad joystick was getting the correct direction
    if (_d == N) {
        printf("North\n");
    } else if (_d == NE) {
        printf("North East\n"); 
    } else if (_d == E) {
        printf("East\n");
    } else if (_d == SE) {
        printf("South East\n");
    } else if (_d == S) {
        printf("South\n");
    } else if (_d == SW) {
        printf("South West\n");
    } else if (_d == W) {
        printf("West\n");
    } else if (_d == NW) {
        printf("North West\n");
    } else {
        printf("Centre\n");
        };*/
        /*if (pad.A_pressed() == true) {
            printf("start pressed\n");
        } else if (pad.A_pressed() == false) {
            printf("start not pressed\n");
            }*/
        
        engine.read_input(pad);
        engine.update(pad, lcd);
        render();
        wait(1.0f/fps);
        
        }
}
void welcome() {
    //print simple display message
    lcd.printString("    SNAKE!    ",0,1); 
    lcd.printString(" Press Start ", 0, 3); 
    lcd.refresh();
     
    //wait flashing LEDs until start button is pressed  
    while ( pad.start_held() == false) {
        lcd.setContrast( pad.read_pot1());
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}
//function to initialise all objects
void init() {
    
    lcd.init();
    pad.init();
    engine.init(HEAD_SIZE, HEAD_SPEED);
}
//function to render the image in screen 
void render() 
{
    lcd.clear();
    engine.draw(lcd);
    lcd.refresh();
}

