#ifndef SNAKETAIL_H
#define SNAKETAIL_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SnakeHead.h"

/** Snake Tail class 
@brief Class to update and draw the tail of the snake
@author Samuel D Lashmar
@date May 2020
*/

class SnakeTail 

{

public: 
    /** Constructor */
    SnakeTail();
    /** Destructor */
    ~SnakeTail();
    /** updates the position of all the tail sgements
    @param 2D vector of previous head coordinates
    @param length of the tail 
    */
    void update(Vector2D headPos, int length);
    /** draws the tail on the LCD screen 
    @param length of the tail 
    */
    void draw(N5110 &lcd, int length);
    

private: 
    //two 100 element arrays for storing the x and y coordinates of the tail segments
    int tailX[100];
    int tailY[100];
    int _x_init, _y_init, prevX, prevY, prev2X, prev2Y, _length;
};

#endif
    