#include "SnakeTail.h"

SnakeTail::SnakeTail()
{
    
}

SnakeTail::~SnakeTail()
{
    
}
/*  The snake tail is drawn as individual segments
    coordinates for each segment are stored in two arrays
    this update function iterates through the segments and changes 
    the coordinates to the previous segments
*/
void SnakeTail::update(Vector2D prevHead, int length) 
{
    _length = length;
    _x_init = prevHead.x;
    _y_init = prevHead.y;
    //printf("x_init = %i\n", _x_init);
    //printf("y_init = %i\n", _y_init);
    prevX = tailX[0];
    prevY = tailY[0];
    tailX[0] = _x_init;
    tailY[0] = _y_init;

    for(int i = 1; i < _length; i++) {
        //stores the current x and y coordinates
        prev2X = tailX[i];
        prev2Y = tailY[i];
        //updtes the current coordinates so the are the same as i-1
        tailX[i] = prevX;
        tailY[i] = prevY;
        //sets previous x and y to the original coordinates for this i 
        prevX = prev2X;
        prevY = prev2Y;
    }
    
    /*debugging print statements to make sure the array is being updated correctly 
    for (int l = 0; l < _length; l++) {
        printf("i = %i\n", l);
        printf("tailX[i] = %i\n", tailX[l]);
        printf("tailY[i] = %i\n", tailY[l]);
        }*/
}
        


void SnakeTail::draw(N5110 &lcd, int length) {
    int _length = length;
    for(int j = 0; j < _length; j++) {
        lcd.drawRect(tailX[j], tailY[j], 2, 2, FILL_BLACK);
        }
}
    
        





    