#ifndef SNAKEHEAD_H
#define SNAKEHEAD_H 

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "time.h"

/** Snake Head Class
*  @author Samuel D Lashmar
*  @brief controls the snake head in the snake game and allows user to access certain variable
*  @date May 2020
*/

class SnakeHead
{

public:
    /** Constructor */
    SnakeHead();
    /** Destructor */
    ~SnakeHead();
    /** Initialise snake head position, speed an direction 
    *@param Snake Head size
    *@param Snake Head speed
    */
    void init(int size, int speed);
    /** Draws snake head on the LCD screen*/
    void draw(N5110 &lcd);
    /** Updates head position */
    void update();
    /** Changes the direction in whihc the head moves
    @param Direction of the joystick (N,E,S,W)
    */
    void change_direction(Direction d);
    /** Sets the velocity of the head
    @param 2D vector for x and y speeds
    */
    void set_velocity(Vector2D v);
    /** gets the current head velocity
    @returns velocity
    */
    Vector2D get_velocity();
    /** Gets the current position of the head
    @returns position
    */
    Vector2D get_pos();
    /** Sets the position of the head
    @param 2D vector of x and y coordinates
    */
    void set_pos(Vector2D p);
    
    
private: 
    Vector2D _velocity;  
    Gamepad pad; 
    int _size;
    int _speed;
    int _x;
    int _y;
};

#endif      