#ifndef GAMEENGINE_H
#define GAMEENGINE_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SnakeHead.h"
#include "SnakeTail.h"

/** Game Engine Class
@author Samuel D Lashmar
@brief Controls the logic of the snake game 
@date May 2020
*/

class GameEngine
{ 

public: 
    /** Constructor */
    GameEngine();
    /** Destructor */
    ~GameEngine(); 
    /** Initialises head, mouse spawn and score
    @param Head size
    @param Head speed
    */
    void init(int head_size, int head_speed);
    /** reads inout from joystick */
    void read_input(Gamepad &pad);
    /** updates all coordinates and checks for wall collisions/mouse eatings */
    void update(Gamepad &pad, N5110 &lcd);
    /** draws the frame on the LCD */
    void draw(N5110 &lcd);
     
    
private:
    /** spawns a mouse from random x and y coordinates */
    void spawn_mouse(N5110 &lcd);
    /** checks if the mouse has been eaten, and if it has new coordinates are generated */
    void check_mouse_eaten(Gamepad &pad);
    /** Checks if the snake head has collided with the wall */
    void check_wall_collision(Gamepad &pad, N5110 &lcd);
    /** game over splash sreen which displays the score as well */
    void game_over(N5110 &lcd, Gamepad &pad);

    
    SnakeHead head;
    SnakeTail tail;
    
    Direction _d;
    
    bool _game_over;
    int _score;
    int _mouse;
    int _head_size;
    int _head_speed; 
    int _mouse_x;
    int _mouse_y;
    int _length;
};

#endif