
#ifndef SNAKE_H
#define SNAKE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Snake Class
* Owen Cavender, University of Leeds
*/

class Snake
{


public:
    Snake();
    /** constructor
    */
    ~Snake();
    /** deconstructor
    */

    enum Directions {           /**enum of directions*/
        up,
        down,
        left,
        right,

    };

    void init();
    /** initialises 'Snake' class
    */
    void get_direction(Gamepad &pad);
    /** reads input from gamepad
    *updates direction
    */
    void render_clear_tail(N5110 &lcd);
    /** clears pixel on the end of snake
    *before everything else on the screen is updated and rendered
    */
    void move_snake();
    /**alters the values assigned to the snake's body
    *based on the _direction set in get_direction
    */
    void apple_collected(N5110 &lcd, Gamepad &pad);
    /** check to see if the apple x,y = snakehead x,y values
    *increases score, triggers a true which causes generation of apple, updates counter
    *Plays a tone and toggles LEDs
    */
    void check_gameover(N5110 &lcd);
    /**checks if game is over based on 3 conditions
    */
    void get_Apple_position(N5110 &lcd);
    /**sets the apple position
    *an update of position is triggered by bool _reset_apple
    */
    void render(N5110 &lcd, Gamepad &pad);
    /**draws the snake, border, and apple during the game
    * if it is game over, it displays the score and a gameo over message
    */



    Vector2D get_Snakehead();
    /**returns _x0, and _y0 values
    */

    int get_countdown();
    /**reurns counter value
    */
    int get_score();
    /**returns score;
    */

private:


    bool get_gameover();
    /** returns _gameover
    *private as it is only used in Snake class
    */

    /**Snake private variables*/
    Directions _direction;
    int _countdown;
    bool _gameover;
    int _score;
    int _reset_apple;

    int _x0;            /**snake position variable*/
    int _y0;
    int _x1;
    int _y1;
    int _x2;
    int _y2;
    int _x3;
    int _y3;
    int _x4;
    int _y4;
    int _x5;
    int _y5;
    int _x6;
    int _y6;
    int _x7;
    int _y7;


    int _apx;       /**apple position variable*/
    int _apy;

};


#endif