/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical appleering
University of Leeds
2019/20

/////////////SNAKE ///////////
Name: Owen Cavender
Username: el17oc
Student ID Number: 201159294
Date: 20/04/2020
*/

//////////////////////////////

//includes
#include "mbed.h"                        //addresses each header file of external classes being used in the programme
#include "Gamepad.h"
#include "N5110.h"
#include "snake.h"
#include "GameEngine.h"


//objects
Gamepad pad;
Snake snake;
N5110 lcd;
GameEngine engine;

//functions
void welcome();
void render();
void init();
void update_snake();


//Serial pc(USBTX, USBRX);

int main()
{

    init();                   //initialises game objects
    welcome();                //displays welcome screen before entering game loop



    while (1) {


        update_snake();                                                     //reads input from gamepad and updates the position of the snake - this is the function influences how the other functions behave
        snake.check_gameover(lcd);                                          //checking if any one of the three game over conditions is true
        //   snake.gameover_true(lcd, pad);                                      //checking if an apple has been collected - increases the score and generates new apple position if apple has been collected
        snake.apple_collected(lcd, pad);
        snake.get_Apple_position(lcd);
        engine.get_LEDs(pad, snake);

        engine.print_countdown(lcd, snake);                                //prints the value of the countdown counter - it will have incremented by 25 if an apple has been collected and would have decreased by 1 if not
        snake.render(lcd, pad);                                            //prints the snake, the apple, the score and the border
        //      snake.print_display_time(lcd);


        wait(0.01);
    }

}

void init()
{
    lcd.init();             //initialises the lcd
    pad.init();             //initialises the gamepad
    snake.init();           //initialises snake class


}

void update_snake()
{
    snake.get_direction(pad);                                          //sets the direction based on buttons pressed on the Gamepad
    snake.render_clear_tail(lcd);                                      //clears the trailing pixel of the snake before updating position to avoid the snake growing with each move - the trailing pixel would be locked and fixed as 1 in its initial position without this
    // =needs to be cleared before _x3, _y3 is updated
    snake.move_snake();                                                //alters the coordinate of each snake bit in accordance with the Gamepad instruction
    engine.get_LEDs(pad, snake);                                       //Turns on on LEDS based on where the snake is in the box
}

void welcome()
{


    while ( pad.start_pressed() == false) {             //main menu - wont enter game loop until start is pressed
        lcd.printString("     SNAKE    ",0,1);          //
        lcd.printString("COLLECT APPLES",0,3);          //game task
        lcd.printString("  Press Start ",0,5);          //instruction
        lcd.setContrast( pad.read_pot1());              //adjust contrast


        pad.leds_off();
        pad.led(1,1);
        wait(0.2);
        pad.led(1,0);                                   //turning on the LEDS in a sequence which reflects the snakes movement
        pad.led(2,1);
        wait (0.2);
        pad.led(2,0);
        pad.led(3,1);
        wait(0.2);
        pad.led(3,0);
        wait(0.1);
        pad.led(6,1);
        wait (0.2);
        pad.led(6,0);
        pad.led(5,1);
        wait (0.2);
        pad.led(5,0);
        pad.led(4,1);
        wait(0.2);

        lcd.refresh();                              //updates screen
    }

}

