#include "GameEngine.h"

GameEngine::GameEngine()        //constructor
{

}

GameEngine::~GameEngine()      //deconstructor
{
}


void GameEngine::print_scores(N5110 &lcd, Snake &snake)
{

    int score = snake.get_score();                                  //gets score from snake class object

    char buffer1[14];
    sprintf(buffer1,"%2d",score);                                  //sprintf is used to print as the program is displaying a variable
    lcd.printString(buffer1,0,48);
}




void GameEngine::get_LEDs(Gamepad &pad, Snake &snake)       //controls LEDs based on snake position
{
    pad.leds_off();                                         //initialise leds
    Vector2D Snakehead = snake.get_Snakehead();             //call values stored in _x0 and _y0 to identify the snakehead
    int _x0 = Snakehead.x;
    int _y0 = Snakehead.y;
    //depending where the snakehead is on the screen, different LEDs will turn on indicating its postion
    // top right led on
    if (_x0 >= 42 && _y0 <= 16) {               //defines paramaters of the top right quadrant of the lcd rectangle and turns on and off the top right LED if the x and y values are in the top right quadrant

        pad.led(4, 1);                        //turn on top right led4
        wait(0.2);                            //wait 0.2 seconds
        pad.led(4, 0);                        //turn it off
    }
    // topleft led on
    if (_x0 <= 42 && _y0 <= 16 ) {             //parameter for top left

        pad.led(1, 1);                          //turns on top left led
        wait(0.2);
        pad.led(1, 0);
    }
    //bottom left                           //defines paramaters of the bottom left quadrant of the rectangle on the lcd display and turns on and off the bottom left LED
    if (_x0 <=42 && _y0 >= 16 ) {

        pad.led(3,1);                       //turns on bottom left led
        wait(0.2);
        pad.led(3, 0);
    }
    //bottom right
    if (_x0 >= 42 && _y0 >= 16) {          //there are some overlap on the symetrical x and y axis where conditions are true in both loops causing leds to coome on at the same time and alternately blink
        // top right led on
        pad.led(6, 1);
        wait(0.2);
        pad.led(6, 0);                      //turns of bottom right led
    } else {
    }
}

void GameEngine::print_countdown(N5110 &lcd, Snake &snake)          //prints counter
{

    int countdown = snake.get_countdown();                         //Accessing the value of the member variale _countdown

    char buffer1[14];
    sprintf(buffer1,"%2d",countdown);                              //printing value onto lcd in each loops. - counter is set to decrement by 1 each loop
    lcd.printString(buffer1,0,4);  //
// printf("  countdown= %d   ", countdown);
}

