#include "snake.h"

Snake::Snake()
{

}

Snake::~Snake()
{
}

void Snake::init()//int x, int y)
{
    _x0 = 48;                           //initialises each part of the snake  //_x0 and _y0 is the snake's head coordinate whose position is followed by the other bits periodically
    _x1 = 48;
    _x2 = 48;
    _x3 = 48;
    _x4 = 48;
    _x5 = 48;

    _y0 = 20;                           //the snakes body is in a vertical positon
    _y1 = 19;
    _y2 = 18;
    _y3 = 17;
    _y4 = 16;
    _y5 = 15;

    _apx = 48;                        //initial apple position - directly in front of snake
    _apy = 25;
    _gameover = false;                //when _gameover = true, game cannot be played
    _reset_apple = false;             //triggers the generation of a new apple position.
    _score = 0;                       //initialises score to 0
    _direction = down;                  //initial direction
    _countdown = 18;                  //initial number of moves is lower than the reset value in order to keep the number of moves low to increase difficulty
}

Vector2D Snake::get_Snakehead()
{
    Vector2D Snakehead;             //defines Snakehead as a Vector
    Snakehead.x = _x0;              //returns _x0, _y0 values
    Snakehead.y = _y0;

    return Snakehead;               //Snakehead position is called and used in GameEngine::get_LEDs by calling this class

}


void Snake::apple_collected(N5110 &lcd, Gamepad &pad)   //checks to see whether an apple has been collected
{

    if((_x0 == _apx) && (_y0 == _apy)) {        // directly comparing position of the apple and the Snakehead by using an and statement to see if the x and y components are equal
        // if they are the same: the score increases, a new apple position is generated, the countdown timer is reset,  LEDS and Speaker are triggered
        _score++;                               //increases score
        _reset_apple = true;                   //causes new apple position to be generated - _reset _apple is compared to a bool true - when an apple is collected a new apple position is generated
        _countdown = _countdown + 25;          //38 is added to the current countdown timer - this larger _countdown is, the further the snake can travel to collect apples.
        pad.tone(1500.0,0.5);                  //if the counter is reset to just 38, there will be some distances the snake cannot as it is further than 38 pixels away - unless the player collects accumulates their available moves
        pad.led(2, 1);                         //toggles middle left led on
        pad.led(4, 1);                          //toggles middle right led on
        wait(0.1);
        pad.led(2, 0);
        pad.led(4, 0);



    } else {
        _countdown = _countdown - 1;           //for each change in position, counter decreases by 1 - the counter represents how many moves you have to collect an apple

    }
}

int Snake::get_countdown()
{
    //allows _countdown value to be called from other classes
    return _countdown;
}


void Snake::check_gameover(N5110 &lcd)
{
    if (_x0 == 15 ||_x0 == 69 || _y0 == 32 || _y0 == 0) {   // the first condition is, if the snakehead coordinate touches the edge of the rectangle, it is gameover
        //the second condition for, game over = true, is if the snake head cooroinate is equal to one of the snake body bits coordinate
        _gameover = true;                                   // the third conditios is game is over if the counter = 0, indicating you've ran out of moves.
    }
    if ((_x0 == _x1 && _y0 == _y1) || (_x0 == _x2 && _y0 == _x2) || (_x0 == _x2 && _y0 == _y2) || (_x0 == _x3 && _y0 == _y3) || (_x0 == _x4 && _y0 == _y4)|| (_x0 == _x5 && _y0 == _y5)|| (_x0 == _x6 && _y0 == _y6)|| (_x0 == _x7 && _y0 == _y7)) {
        _gameover = true;
    }
    if(_countdown == 0) {
        _gameover = true;

    }
}

void Snake::render(N5110 &lcd, Gamepad &pad)                     //final function in the main function's while loop as the screen updates based on all any changes which occur in the functions
{
    lcd.clear();                                    //clears the lcd before assigning what is to be printed

    // plot the apple
    lcd.setPixel(_apx, _apy,1);                     //plot apple position -whether it is a new position or the same position

    //plot the border
    lcd.drawRect(15, 0, 54, 32, FILL_TRANSPARENT);  //plots border of snake map

    //plot the snake
    lcd.setPixel(_x0, _y0,1);                       //plots snake body's new position changed by move_snake() function
    lcd.setPixel(_x1, _y1,1);
    lcd.setPixel(_x2, _y2,1);
    lcd.setPixel(_x3, _y3,1);
    lcd.setPixel(_x4, _y4,1);
    lcd.setPixel(_x5, _y5,1);
    lcd.setPixel(_x6, _y6,1);
    lcd.setPixel(_x7, _y7,1);                        //new position of the end bit of the snake is plotted here
    // _x0, _y0  old positional values are cleared previously before this function in an earlier one as otherwise the program would lose reference of that pixel when the position updates and we wouldnt be able to clear it


    char buffer1[14];
    sprintf(buffer1,"   %2d   %2d",_score, _countdown);
    lcd.printString(buffer1,0,5);

    if (_gameover == true) {                                    //As _gameover is a member variable, if the condition is the previous function is met, the true value will be stored in _gameover and can be accessed in this function
        lcd.clear();                                            //

        pad.led(1,1);
        pad.led(4,1);
        lcd.printString( "  Game Over  ", 0, 1 );               //prints game over message
        lcd.printString( " ~~~~~~~<:>-<", 0, 3 );               // prints symbolic snake
        char buffer1[14];
        sprintf(buffer1,"  Score: %2d", _score);                          //prints your score - cannot simply use N5110::printString as we need to output a value and the Number of inputs wouldnt match the function declaration
        lcd.printString(buffer1,0,4);                                   ///print score


    }

//   char buffer2[14];
    // sprintf(buffer2,"%2d",_score);
    // lcd.printString(buffer2,0,3);

    lcd.refresh();                                       //updates the lcd display according to the code in this function
}





void Snake::get_direction(Gamepad &pad)  //gets the direction based on the input of the gamepad
{
    // int x;                            // int x was used as a variable to test whether the button were generating the correct output
    Directions direction = _direction;   //"direction" stores the previous value of _direction to stop the snake going in the opposite direction to the way its travelling

    if(direction != left) {             //if current direction is left, the not statement is false blocking access to the next command from the 'A' button preventing _direction being set to right
        if (pad.A_pressed()) {

            _direction = right;         //the snake direction is stored in _direction so on the next loop direction = right
            //       x=1;
        }
    }
    if(direction != right) {
        if (pad.Y_pressed()) {

            _direction = left;
            //      x=2;
        }

    }
    if(direction != up) {
        if (pad.B_pressed()) {
            //       x=3;
            _direction = down;
        }
    }
    if(direction != down) {
        if (pad.X_pressed()) {

            _direction = up;
            //       x=4;
        }
    } else {
        _direction = _direction;            // setting the direction equal to itself if no button is pressed means the snake will move automatically once direction is set

    }
    //  printf("direction %d ", x);        //printf statements used in CoolTerm to check whether the input commands where working correctly
}



void Snake::move_snake()           //assigns the new values of the snake position
{
    if (_direction == down) {       //shifting the snake position bit by bit, with respect to _x0 and _y0;
        _x7 = _x6;                //coordinate _x[i], _y[i] = _x[i-1], _y[i-1]
        _y7 = _y6;
        _x6 = _x5;
        _y6 = _y5;
        _x5 = _x4;
        _y5 = _y4;
        _x4 = _x3;
        _y4 = _y3;
        _x3 = _x2;
        _y3 = _y2;
        _x2 = _x1;
        _y2 = _y1;
        _x1 = _x0;
        _y1 = _y0;               //_x1 ,_y1 and  must be assingned to _x0,_y0 before its own position updates otherwise bit 0 and bit 1 would be plotted as 1 pixel

        _x0 = _x0;
        _y0 = _y0 + 1;          //changes the position one bit at a time so the snake can only move horizontally or vertically
    }
    if (_direction == up) {
        _x7 = _x6;
        _y7 = _y6;
        _x6 = _x5;
        _y6 = _y5;
        _x5 = _x4;
        _y5 = _y4;
        _x4 = _x3;
        _y4 = _y3;
        _x3 = _x2;
        _y3 = _y2;
        _x2 = _x1;
        _y2 = _y1;
        _x1 = _x0;
        _y1 = _y0;

        _x0 = _x0;             // x remains constant
        _y0 = _y0 - 1;          //y decerases by 1 to move up as the y axis decreases from top to bottom

    }
    if (_direction == left) {
        _x7 = _x6;
        _y7 = _y6;
        _x6 = _x5;
        _y6 = _y5;
        _x5 = _x4;
        _y5 = _y4;
        _x4 = _x3;
        _y4 = _y3;
        _x3 = _x2;
        _y3 = _y2;
        _x2 = _x1;
        _y2 = _y1;
        _x1 = _x0;
        _y1 = _y0;

        _x0 = _x0 - 1;       //changes x=x-1
        _y0 = _y0;           //y remains the same to move left



    }

    if (_direction == right) {
        _x7 = _x6;
        _y7 = _y6;
        _x6 = _x5;
        _y6 = _y5;
        _x5 = _x4;
        _y5 = _y4;
        _x4 = _x3;
        _y4 = _y3;
        _x3 = _x2;
        _y3 = _y2;
        _x2 = _x1;
        _y2 = _y1;
        _x1 = _x0;
        _y1 = _y0;

        _x0 = _x0 + 1;
        _y0 = _y0;


    }
}


void Snake::render_clear_tail(N5110 &lcd)
{

    lcd.setPixel(_x7, _y7, false);                       //sets the end pixel to 0. it must be set to 0 before its position updates otherwise the snakebody will grow continually from _x7, _y7 coordinate
}

bool Snake::get_gameover()                               //methods to access member variables of the class
{
    return _gameover;
}
int Snake::get_score()
{
    return _score;
}





void Snake::get_Apple_position(N5110 &lcd)
{
    if(_reset_apple == true) {      // _reset_apple is a triggered when an apple is collected and causes a new Apple position to be randomly generated
        _reset_apple = false;         // returned to false immediately so another position can be generated function can be triggered again in the next loop
        lcd.setPixel(_apx, _apy,0);     //sets the exisiting apple position to 0 to remove it from lcd.
        _apx = rand()%52+16;         //54 = width of the rectangle on the lcd. - the x value of the apple has a range of 52 so it cannot spawn in either side of the wall                                 
        _apy = rand()%28+2;        // the range is from 16 to 69 as the lowest x coordinate of the rectangle is 15 and the highest is 69
    }


}

    
