/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20
 
Name:Wu Chenhao
Username: el17c2w
Student ID Number: 201199595
Date: 2020/5
*/

///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Engine.h"
#include "dust.h"

#ifdef WITH_TESTING
# include "tests.h"
#endif

#define PADDLE_WIDTH 10
#define PADDLE_HEIGHT 2
#define BALL_SIZE 2
#define BALL2_SIZE 2
#define BALL_SPEED 2
#define THING_SIZE 10
#define REPADDLE_SIZE 40


/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Engine pong;
///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
void menu();
void loading();
void producer();

///////////// functions ////////////////
int main()
{
#ifdef WITH_TESTING
    int number_of_failures = run_all_tests();
    if(number_of_failures > 0) return number_of_failures;
#endif
    int fps = 8;  // frames per second
    while(1){
        init();
        menu();
        if (pad.check_event(Gamepad::Y_PRESSED) == true){
            while(pad.check_event(Gamepad::BACK_PRESSED) == false){
                init();
                welcome();
                if(pad.check_event(Gamepad::START_PRESSED) == false) {
                    loading();
                    while (1) {
                        pong.read_input(pad);
                        pong.update(lcd,pad);
                        // The world
                        pong.The_world(lcd, pad);
                        // Bite the dust
                        pong.bite_dust(lcd, pad);
                        render();
                        wait(1.0f/fps);
                    }
                }
                wait(0.1);
            }
        }
        if(pad.check_event(Gamepad::A_PRESSED) == true){
                    while(pad.check_event(Gamepad::BACK_PRESSED) == false){
                        init();
                        producer();
                    }
        }
        wait(0.1);
    }
}

// refresh the game and redraw the graph
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    pong.draw(lcd);
    lcd.refresh();
}

void init()     // initialies all classes and libraries
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
    // initialise the game with correct ball and paddle sizes
    pong.init(PADDLE_WIDTH,PADDLE_HEIGHT,BALL_SIZE,BALL2_SIZE,BALL_SPEED,THING_SIZE,REPADDLE_SIZE);
}


// set the menu of the game
void menu()    // this function draws each frame on the LCD
{
    lcd.clear();
    lcd.printString("Press button",0,0);
    lcd.printString("to select",0,1);
    lcd.printString("Y: Breakout ",0,2);
    lcd.printString("   clone",0,3);
    lcd.printString("A: Made by",0,4);
    lcd.refresh();
    wait(0.4);
}


void producer() 
{
        lcd.clear();
        lcd.printString(" Produced by:",0,1);
        lcd.printString(" Chenhao Wu   ",0,3);
        lcd.printString(" 201199595 ",0,4);
        lcd.refresh();
        wait(0.4);
}

void welcome() {   // simple splash screen displayed on start-up
    
    lcd.printString("Breakout clone    ",0,1);
    lcd.printString("     !!!",0,2);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

// set the loading state
void loading(){
    lcd.clear();
    lcd.printString("   JOJO's advanture!!!    ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("   READY!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("       3     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("       2     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("       1     ",0,3);
    lcd.refresh();
    wait_ms(500);
    lcd.clear();
    lcd.printString("     Fight!!!     ",0,3);
    lcd.refresh();
    wait_ms(500);
}