#ifndef ENGINE_H
#define ENGINE_H
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ball.h"
#include "Ball2.h"
#include "Paddle.h"
#include "Thing.h"
#include "RePaddle.h"

// gap from edge of screen
#define GAP 2
class Engine
{
    public:
        Engine();
        ~Engine();
        void init(int paddle_width,int paddle_height,int ball_size,int ball2_size,int speed,int thing_size, int repaddle_size);
        void read_input(Gamepad &pad);
        void update(N5110 &lcd, Gamepad &pad);
        void draw(N5110 &lcd);    
        void The_world(N5110 &lcd, Gamepad &pad);
        void bite_dust(N5110 &lcd, Gamepad &pad);
    
    private:
        void check_reflection(Gamepad &pad);
        void check_wall_collision(Gamepad &pad);
        void check_paddle_collisions(Gamepad &pad);
        void check_thing_collisions(Gamepad &pad);
        void check_goal(Gamepad &pad);
        void print_scores(N5110 &lcd);
        void check_ball2_reflection(Gamepad &pad);
        void check_ball2_wall_collision(Gamepad &pad);
        void check_ball2_paddle_collisions(Gamepad &pad);
        void check_ball2_thing_collisions(Gamepad &pad);
        void check_ball2_goal(Gamepad &pad);
        void check_ball2(Gamepad &pad);
        
        Paddle _p1;

        int _paddle_width;
        int _paddle_height;
        int _ball_size;
        int _ball2_size;
        int _thing_size;
        int _repaddle_size;
        int _speed;
        
        // x positions of the paddles
        int _p1x;
        int _p2x;
        int _p1y;
        
        Ball2 _ball2;
        Ball _ball;
        Thing _thing;
        RePaddle _repaddle;
        
        Direction _d;
        float _mag;
};
#endif