#ifndef SPLASH_H
#define SPLASH_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Ball.h"
#include "Sprites.h"

/** Splash class
@brief Class for playing introductory animations and displaying student info.
@version 1.0
@author Kaif Kutchwala
@date May 2020
*/

class Splash {
    private:
        //objects
        N5110 *_lcd;
        Ball *_ball;

    public:
        /** Constructor */
        Splash(N5110 &lcd, Ball &ball);

        /** Destructor */
        ~Splash();
        
        /** @brief displays student info on lcd */
        void displayInfo();
        
        /** @brief plays game intro animation on lcd */
        void playIntro();
        
        /** @brief draws game logo on lcd */
        void drawLogo(int x, int y);

    private:
        // functions draws logo without middle 'O', needed for intro animation
        void draw_name();
        
        void player_enter_animation();
    
        void kick_animation();
    
        void shot_animation();
        
        // animation where constrast starts from zero and increases slowly.
        void contrast_slide();
};

#endif