#include "Splash.h"

int ball_x = 39;
int ball_y = 21;

Splash::Splash(N5110 &lcd, Ball &ball) {
    _lcd = &lcd;
    _ball = &ball;
}

Splash::~Splash() {}

void Splash::displayInfo() {
    _lcd -> clear(); //clear screen before starting animation
    _lcd -> setContrast(0);
    //print info
    _lcd -> printString("Kaif Kutchwala", 1, 1);
    _lcd -> printString("EL18KK", 24, 2);
    _lcd -> printString("ELEC 2645", 16, 3);
    _lcd -> printString("201267448", 15, 4);
    _lcd -> refresh();
    //slowly increase contrast to create fade-in animation
    contrast_slide();
    wait(1);
    _lcd -> clear(); //clear screen after animation
}

void Splash::playIntro() {
    _lcd -> clear();
    _lcd -> setContrast(0);
    draw_name();
    _ball -> drawBall(ball_x, ball_y, 6);
    contrast_slide();
    wait(1);
    player_enter_animation();
    kick_animation();
    shot_animation();
    _lcd -> refresh();
    wait(1);
    _lcd -> clear();
}
void Splash::drawLogo(int x, int y) {
    _lcd -> drawSprite(x, y, 15, 9, (int * ) letter_S);
    _lcd -> drawSprite((x + 9), y, 15, 9, (int * ) letter_h); //+9
    _ball -> drawBall((x + 24), (y + 7), 6); //+9 +12
    _ball -> drawBall((x + 38), (y + 7), 6); //+32 +3
    _lcd -> drawSprite((x + 47), y, 15, 9, (int * ) letter_t); //+47
}
void Splash::draw_name() {
    _lcd -> drawSprite(15, 14, 15, 9, (int * ) letter_S);
    _lcd -> drawSprite(24, 14, 15, 9, (int * ) letter_h);
    _ball -> drawBall(53, 21, 6);
    _lcd -> drawSprite(62, 14, 15, 9, (int * ) letter_t);
    _lcd -> printString("Game by", 21, 4);
    _lcd -> printString("Kaif Kutchwala", 0, 5);
}

void Splash::contrast_slide() {
    for (float contrast = 0.40f ; contrast < 0.51f ; contrast += 0.01f ) {
        _lcd -> setContrast(contrast);
        //printf("Contrast = %.2f \n",contrast);
        _lcd -> refresh();
        wait_ms(100);
    }
}
void Splash::player_enter_animation() {
    int sprite_X = 25;
    int sprite_Y = -10;
    while (sprite_X != 35 && sprite_Y != 0) {
        _lcd -> clear(); //clear screen before starting animation
        _lcd -> drawSprite(sprite_X, sprite_Y, 20, 15, (int * ) player_fsm[0]);
        draw_name();
        _ball -> drawBall(ball_x, ball_y, 6);
        //printf("%d \n",sprite_X);
        //printf("%d \n",sprite_Y);
        _lcd -> refresh();
        sprite_X++;
        sprite_Y++;
        wait(0.1);
    }
}
void Splash::kick_animation() {
    int state = 0;
    while (state < 3) {
        switch (state) {
        case 0:
            state = 1;
            break;
        case 1:
            state = 2;
            break;
        case 2:
            state = 3;
            break;
        case 3:
            state = 0;
            break;
        default:
            error("Invalid state");
            break;
        }
    }
    _lcd -> drawSprite(35, 0, 20, 15, (int * ) player_fsm[state]);
    draw_name();
    _ball -> drawBall(ball_x, ball_y, 6);
    _lcd -> refresh();
    _lcd -> clear();
    wait(0.1);
}
void Splash::shot_animation() {
    while (ball_x != -7 && ball_y != 48) {
        _lcd -> drawSprite(35, 0, 20, 15, (int * ) player_fsm[4]);
        draw_name();
        _ball -> drawBall(ball_x, ball_y, 6);
        _lcd -> refresh();
        _lcd -> clear();
        ball_x--;
        ball_y++;
        wait_ms(30);
    }
}