/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Kaif Kutchwala
Username: el18kk
Student ID Number: 201267448
Date: May 2020
Game: Shoot!
*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Ball.h"
#include "Splash.h"
#include "Game.h"
#include "test.h"
#include "Instructions.h"
#include "Sprites.h"

//objects
Gamepad pad;
N5110 lcd;
Ball ball(lcd);
Splash splash(lcd, ball);
Game game(lcd, pad, ball);
Instructions instruction(lcd, pad, ball, game);

//functions
void init();
void display_menu();
void game_loop();
void how_to();
void display_settings();

//variables
int page = 1;

int main() {
    init();
    while (1) {
        //ball.level_loop();
        display_menu();
        page = 1; //reset instructions page
        if (pad.A_pressed()) {
            game_loop(); //if A is pressed, play game
        } else if (pad.B_pressed()) {
            wait(0.3); //debounce
            while (!pad.B_pressed()) { how_to(); } //if B, show instructions
            wait(0.3);
            pad.reset_buttons();
            pad.leds(0.0);
        } else if (pad.X_pressed()) {
            while (!pad.B_pressed()) { display_settings(); } // if C, settings
            wait(0.3);
            pad.reset_buttons();
        } else if (pad.Y_pressed()) { // if Y, turn off lcd and leds
            lcd.turnOff();
            pad.leds(0.0);
        }
    }
}
void init() { //initialise all objects, display splash screen and intro
    run_all_tests();
    lcd.init();
    pad.init();
    lcd.setContrast(0.5);
    lcd.backLightOn();
    splash.displayInfo();
    splash.playIntro();
    game.init();
}
void display_menu() {
    splash.drawLogo(13, 0);
    lcd.printString("Play", 2, 2);
    lcd.printString("How-To?", 2, 3);
    lcd.printString("Settings", 2, 4);
    lcd.printString("Exit", 2, 5);
    lcd.drawSprite(28, 15, 9, 9, (int * ) a_button);
    lcd.drawSprite(45, 23, 9, 9, (int * ) b_button);
    lcd.drawSprite(52, 31, 9, 9, (int * ) x_button);
    lcd.drawSprite(28, 39, 9, 9, (int * ) y_button);
    // displaying highscore
    lcd.drawSprite(65, 21, 9, 15, (int * ) highscore_icon);
    lcd.drawRect(65, 30, 15, 12, FILL_TRANSPARENT);
    int highscore = game.get_highscore();
    char buffer[12];
    sprintf(buffer, "%d", highscore);
    lcd.printString(buffer, 67, 4);
    lcd.refresh();
    wait(0.1);
    lcd.clear();
}
void game_loop() {
    char buffer_score[14];
    char buffer_high_score[14];
    game.init(); //initialise
    wait(0.2); //debounce
    game.play(); //play game
//////////////////// game has now ended //////////////////////////////////////
    lcd.clear(); //clear screen once game is over and display apt message
    // store player score and top score in buffer
    sprintf(buffer_score, "Your Score: %d", game.get_score());
    sprintf(buffer_high_score, "Top Score: %d", game.get_highscore());
    lcd.printString("GAME OVER", 15, 1);
    lcd.printString(buffer_score,0,3);
    lcd.printString(buffer_high_score,0,4);
    lcd.refresh();
    game.playGoalSound(3); // game over sound effect
    wait(3);
    pad.reset_buttons(); //to ensure no accidental selection on menu
}
void how_to() {
    pad.leds(0.0);
    if (pad.get_direction() == N) {
        page--;
    } else if (pad.get_direction() == S || page == 3 || page == 4) {
        page++; //pages 3 and 4 don't need scrolling so increase page number
    }
    if (page > 7) {
        page = 7; //only 7 pages
    }
    if (page < 1) {
        page = 1;
    }
    instruction.set_page(page);
    instruction.display(); //display page
    wait(0.2);
}
void display_settings() {
    lcd.printString("Settings", 20, 0);
    lcd.printString("Set Contrast", 0, 1);
    lcd.printString("using Pot 1", 0, 2);
    lcd.printString("Hit B to Exit", 0, 5);
    lcd.drawRect(0, 24, 84, 8, FILL_TRANSPARENT);
    float pot_1_val = pad.read_pot1(); // read pot 1 value
    //printf("POT 1 = %.2f \n", pot_1_val); 
    //fill bar proportionally to pot 1 value
    lcd.drawRect(0, 24, (int)(84 * pot_1_val), 8, FILL_BLACK); 
    lcd.setContrast(pot_1_val); //set contrast using pot 1 value
    lcd.refresh();
    wait_ms(100);
    lcd.clear();
}