#ifndef INSTRUCTIONS_H
#define INSTRUCTIONS_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Ball.h"
#include "Game.h"

/** Instructions class
@brief Class for displaying and manipulating instruction screens. 
@version 1.0
@author Kaif Kutchwala
@date May 2020
*/

class Instructions {
    
    private:
        //objects
        N5110 *_lcd;
        Gamepad *_pad;
        Ball *_ball;
        Game *_game;
    
    public:
         /** Constructor */
        Instructions(N5110 &lcd, Gamepad &pad, Ball &ball, Game &game);
        
        /** Destructor */
        ~Instructions();
        
        /** @brief initialises page value to 1*/
        void init();
        
        /** @brief displays page based on number stored in _page variable.*/
        void display();
        
        //accessors and mutators
        /** @brief sets page number to be played/displayed
        * @param page @details integer value in range 1-7
        */
        void set_page( int page);
        
        /** @brief Get page number of page being displayed/played
        * @returns integer value in range 1 to 7 referring to pages 1-7
        */
        int get_page();
        
    private:
        //functions
        // functions below display contents for respective pages
        void display_page1();
        void display_page2();
        void display_page3();
        void display_page4();
        void display_page5();
        void display_page6();
        void display_page7();
        
        /** @brief draws pointer as seen in game
        * @param x_val @details integer value of x coordinate at which pointer 
        * ends
        */
        void draw_pointer(int x_val);
        
        /** @brief draws power meter as seen in game
        * @param y_val @details integer value of y coordinate that determines 
        * how full the power meter is
        */
        void draw_power_meter(int y_val);
        
        //variables
        int _page;
};
#endif