#include "Instructions.h"

Instructions::Instructions(N5110 &lcd, Gamepad &pad, Ball &ball, Game &game) {
    _lcd = &lcd;
    _pad = &pad;
    _ball = &ball;
    _game = &game;
}
Instructions::~Instructions() {}

void Instructions::init() {
    _page = 1;
}

void Instructions::display() {
    //printf("Checking page number = %d \n", _page);
    if (_page == 1) {
        display_page1();
    } else if (_page == 2) {
        display_page2();
    } else if (_page == 3) {
        display_page3();
    } else if (_page == 4) {
        display_page4();
    } else if (_page == 5) {
        display_page5();
    } else if (_page == 6) {
        display_page6();
    } else if (_page == 7) {
        display_page7();
    } else {
        error("Invalid Page number");
    }
    wait_ms(100);
    _lcd -> refresh();
    _lcd -> clear();
}
void Instructions::set_page(int page) {
    _page = page;
}
int Instructions::get_page() {
    int val = _page;
    return val;
}
void Instructions::display_page1() {
    _lcd -> printString("Instructions:", 5, 0);
    _lcd -> printString("Use Joystick", 0, 1);
    _lcd -> printString("to scroll", 0, 2);
    _lcd -> printString("up and down", 0, 3);
    _lcd -> drawSprite(75, 9, 7, 9, (int * ) up_arrow);
    _lcd -> drawSprite(75, 17, 9, 9, (int * ) joystick);
    _lcd -> drawSprite(75, 27, 7, 9, (int * ) down_arrow);
    _lcd -> printString("to exit", 28, 5);
    _lcd -> drawSprite(17, 39, 9, 9, (int * ) b_button);
}
void Instructions::display_page2() {
    _lcd -> printString("Button Layout", 5, 0);
    _lcd -> printString("on Gamepad:", 5, 1);
    _lcd -> drawSprite(38, 18, 9, 9, (int * ) x_button);
    _lcd -> drawSprite(48, 27, 9, 9, (int * ) a_button);
    _lcd -> drawSprite(28, 27, 9, 9, (int * ) y_button);
    _lcd -> drawSprite(38, 37, 9, 9, (int * ) b_button);
}
void Instructions::display_page3() {
    int x_val = 8;
    int dir = 2;
    while (!_pad -> A_pressed()) {
        _lcd -> printString("How to play?", 5, 0);
        _lcd -> printString("Press  to stop", 0, 1);
        _lcd -> printString("pointer", 0, 2);
        _lcd -> drawSprite(31, 8, 9, 9, (int * ) a_button);
        draw_pointer(x_val);
        x_val += dir;
        if (x_val == 76) {
            dir = -2;
        } else if (x_val == 8) {
            dir = 2;
        }
        wait_ms(100);
        _lcd -> refresh();
        _lcd -> clear();
    }
}
void Instructions::display_page4() {
    int y_val = 8;
    int dir = 2;
    while (!_pad -> B_pressed()) {
        _lcd -> printString("How to play?", 5, 0);
        _lcd -> printString("Press  to set", 0, 1);
        _lcd -> printString("power.", 0, 2);
        _lcd -> drawSprite(31, 8, 9, 9, (int * ) b_button);
        draw_power_meter(y_val);
        y_val += dir;
        if (y_val == 20) {
            dir = -2;
        } else if (y_val == 0) {
            dir = 2;
        }
        wait_ms(100);
        _lcd -> refresh();
        _lcd -> clear();
    }
    wait(0.2);
    _pad -> reset_buttons();
}
void Instructions::display_page5() {
    _lcd -> printString("Lives: ", 0, 0);
    _lcd -> printString("Lives are", 14, 1);
    _lcd -> printString("shown by LEDs", 6, 2);
    _lcd -> printString("+1 life after", 3, 4);
    _lcd -> printString("every 5 points", 0, 5);
    int val[6] = {1, 1, 1, 1, 1, 1};
    _game -> updateLeds(val);
}
void Instructions::display_page6() {
    _lcd -> drawSprite(7, 7, 24, 70, (int * ) goal);
    _lcd -> drawRect(42, 9, 34, 22, FILL_BLACK);
    _lcd -> drawRect(0, 37, 84, 8, FILL_WHITE);
    _lcd -> printString("Levels:", 3, 0);
    _lcd -> printString("Avoid obstacle ", 0, 4);
    _lcd -> printString("to score.", 0, 5);
}
void Instructions::display_page7() {
    _lcd -> printString("Tip:", 0, 0);
    _lcd -> printString("Too much", 18, 1);
    _lcd -> printString("or too little", 6, 2);
    _lcd -> printString("power will", 12, 3);
    _lcd -> printString("miss the goal!", 3, 4);
}

void Instructions::draw_pointer(int x_val) {
    _lcd -> drawLine(WIDTH / 2 - 5, 41, x_val, HEIGHT / 2 + 5, 1);
    _lcd -> drawLine(WIDTH / 2 + 5, 41, x_val, HEIGHT / 2 + 5, 1);
    _lcd -> drawLine(WIDTH / 2 + 5, 41, WIDTH / 2 - 5, 41, 1);
}
void Instructions::draw_power_meter(int y_val) {
    _lcd -> drawRect(39, 27, 6, 20, FILL_TRANSPARENT);
    _lcd -> drawRect(39, 27, 6, y_val, FILL_BLACK);
}