#ifndef BALL_H
#define BALL_H

#include <cmath>
#include "mbed.h"
#include "Gamepad.h"
#include "Sprites.h"
#include "N5110.h"

#define BALL_INIT_X 42
#define BALL_INIT_Y 49

/** Ball class
@brief Class for manipulating the ball in the game, displaying levels and 
checking for goal conditions. 
@version 1.0
@author Kaif Kutchwala
@date May 2020
*/

class Ball {
    private:
        //objects
        N5110 *_lcd;

    public:
        /** Constructor */
        Ball(N5110 &lcd);

        /** Destructor */
        ~Ball();
    
        /** @brief initialises ball position, radius and level */
        void init();
    
        /** @brief Draws ball at position (x,y) 
        * @param x @details x coordinate of specified position 
        * @param y @details y coordinate of specified position 
        * @param radius @details radius of ball 
        */
        void drawBall(int x, int y, int radius);
    
        /** @brief Plays animation of ball being shot based on user input. 
        * @param user_input_x @details x coordinate of final position 
        * @param user_input_y @details y coordinate of final position
        */
        void playShot(int user_input_x, int user_input_y);
    
        /** @brief displays constant background w/o obstacles */
        void displayBackground();
    
        /** @brief displays obstacles for level on lcd
        * @param level @details specifies level number
        */
        void displayLevel(int level);
    
        /** @brief checks if goal has been scored or not and updates
        * @param limit @details sets max limit for random generator
        * @param x @details sets x coordinate of shot to be checked
        * @param y @details sets y coordinate of shot to be checked
        * @returns bool value corresponding to whether goal has been scored
        * or not
        */
        bool isGoal(int level, int x, int y);
    
        //void level_loop(); //displays all levels
    
        //accesors and mutators
        /** @brief sets level to be played/displayed
        * @param level @details integer value in range 1-10
        */
        void set_level(int level);
        
        /** @brief Get level being displayed/played
        * @returns integer value in range 1 to 10 referring to levels 1-10
        */
        int get_level();
        
        /** @brief Get position of the ball on lcd screen
        * @returns value in Vector2D format {x_coordinate, y_coordinate}
        */
        Vector2D get_position();

    private:
        //functions
        // functions below draw obstacles for corresponding level on lcd
        void level_1();
        void level_2();
        void level_3();
        void level_4();
        void level_5();
        void level_6();
        void level_7();
        void level_8();
        void level_9();
        void level_10();
        // functions below check if goal has been scored for given coordinates
        // for corresponding level
        void check_level_1(int x, int y);
        void check_level_2(int x, int y);
        void check_level_3(int x, int y);
        void check_level_4(int x, int y);
        void check_level_5(int x, int y);
        void check_level_6(int x, int y);
        void check_level_7(int x, int y);
        void check_level_8(int x, int y);
        void check_level_9(int x, int y);
        void check_level_10(int x, int y);
        //variables
        int _user_input_x;
        int _user_input_y;
        int _ball_x;
        int _ball_y;
        int _radius;
        int _height;
        int _level;
        bool _status;
        bool _goal;
};
#endif