#include "Ball.h"

Ball::Ball(N5110 &lcd) {
    _lcd = &lcd;
}

Ball::~Ball() {}

void Ball::init() {
    _ball_x = BALL_INIT_X;
    _ball_y = BALL_INIT_Y;
    _radius = 6;
    _level = 1;
}

void Ball::drawBall(int x, int y, int radius) {
    _ball_x = x;
    _ball_y = y;
    _radius = radius;
    //white background so visible over obstacles
    _lcd -> drawCircle(_ball_x, _ball_y, _radius, FILL_WHITE);
    _lcd -> drawCircle(_ball_x, _ball_y, _radius, FILL_TRANSPARENT); //outline
    _lcd -> drawCircle(_ball_x, _ball_y, (_radius / 2), FILL_BLACK); //centre circle
    _lcd -> drawLine(_ball_x, (_ball_y - _radius), _ball_x, (_ball_y + _radius), 1); //vertical line
    _lcd -> drawLine((_ball_x - _radius), _ball_y, (_ball_x + _radius), _ball_y, 1); //horizontal line
}

void Ball::playShot(int user_input_x, int user_input_y) {
    int delay = 0;
    //printf("level (in ball) = %d \n",_level);
    _user_input_x = user_input_x;
    _user_input_y = user_input_y;
    //convert _user_input_y (range 3-28) to delay in range 10-40 ms  
    //max power shortest delay i.e. ball moves faster and vice versa
    delay = (((_user_input_y - 3) * (30)) / (25)) + 10 ;
    //printf("delay = %d \n",delay);
    //increase or decrease coordinate value until input coordinates are reached
    while (_user_input_x < _ball_x || _user_input_y < _ball_y) {
        displayBackground();
        //decide direction based on whether coordinate is less or greater
        if (_user_input_x < _ball_x) { _ball_x -= 1; }
        else if (_user_input_x > _ball_x) { _ball_x += 1; }
        if (_user_input_y < _ball_y) {_ball_y -= 1; }
        else if (_user_input_y > _ball_y) { _ball_y += 1; }
        drawBall(_ball_x, _ball_y, _radius);
        if (_ball_y >= 35) {  _radius = 5; } //ball moved further so reduce size
        else if (_ball_y <= 30) { _radius = 3; } //ball is furthest & smallest
        //printf("ball x pos = %d \n", _ball_x);
        //printf("ball y pos = %d \n", _ball_y);
        wait_ms(delay);
        _lcd -> refresh();
        _lcd -> clear();
    }
}

void Ball::displayBackground() {
    //draw goal
    _lcd -> drawSprite(7, 0, 24, 70, (int * ) goal);
    //draw grass
    _lcd -> drawSprite(1, 17, 7, 7, (int * ) grass);
    _lcd -> drawSprite(76, 17, 7, 7, (int * ) grass);
    _lcd -> drawSprite(67, 26, 3, 3, (int * ) grass_small);
    _lcd -> drawSprite(67, 26, 3, 3, (int * ) grass_small);
    _lcd -> drawSprite(6, 33, 3, 3, (int * ) grass_small);
    _lcd -> drawSprite(72, 32, 3, 3, (int * ) grass_small);
    _lcd -> drawSprite(55, 43, 3, 3, (int * ) grass_small);
    _lcd -> drawSprite(20, 39, 3, 3, (int * ) grass_small);
    _lcd -> drawSprite(16, 29, 3, 3, (int * ) grass_small);
    //ground line
    _lcd -> drawLine(0, 24, 84, 24, 1);
    //score card
    _lcd -> drawRect(0, 38, 15, 11, FILL_TRANSPARENT);
    //power meter
    _lcd -> drawRect(77, 27, 6, 20, FILL_TRANSPARENT);
    //display level
    displayLevel(_level);
}
bool Ball::isGoal(int level, int x, int y) {
    //printf("Checking if goal");
    _goal = false;
    if(level == 1) { check_level_1(x, y); }
    else if(level == 2) { check_level_2(x, y); } 
    else if(level == 3) { check_level_3(x, y); } 
    else if(level == 4) { check_level_4(x, y); } 
    else if(level == 5) { check_level_5(x, y); } 
    else if(level == 6) { check_level_6(x, y); } 
    else if(level == 7) { check_level_7(x, y); } 
    else if(level == 8) { check_level_8(x, y); } 
    else if(level == 9) { check_level_9(x, y); } 
    else if(level == 10) { check_level_10(x, y); } 
    //printf("goal_status = %d \n" , _goal);
    return _goal;
}

void Ball::set_level(int level) {
    _level = level;
}
int Ball::get_level() {
    int val = _level;
    return val;
}
Vector2D Ball::get_position() {
    Vector2D val = {
        _ball_x,
        _ball_y
    };
    return val;
}
void Ball::displayLevel(int level) {
    if(level == 1) { level_1(); }
    else if(level == 2) { level_2(); }
    else if(level == 3) { level_3(); }  
    else if(level == 4) { level_4(); } 
    else if(level == 5) { level_5(); }   
    else if(level == 6) { level_6(); } 
    else if(level == 7) { level_7(); } 
    else if(level == 8) { level_8(); } 
    else if(level == 9) { level_9(); } 
    else if(level == 10) { level_10(); } 
    else { error("Invalid Level"); } 
}
void Ball::level_1() {
    _lcd -> drawRect(8, 1, 68, 24, FILL_TRANSPARENT); /// goal is completely open
}
void Ball::level_2() {
    _lcd -> drawRect(8, 1, 34, 24, FILL_BLACK); /// LEFT HALF BLOCKED
}
void Ball::level_3() {
    _lcd -> drawRect(42, 1, 34, 24, FILL_BLACK); /// RIGHT HALF BLOCKED
}
void Ball::level_4() {
    _lcd -> drawRect(31, 1, 22, 24, FILL_BLACK); /// MIDDLE BLOCKED
}
void Ball::level_5() {
    _lcd -> drawRect(8, 1, 68, 8, FILL_BLACK); /// TOP HALF BLOCKED
}
void Ball::level_6() {
    _lcd -> drawRect(8, 16, 68, 8, FILL_BLACK); /// BOTTOM HALF BLOCKED
}
void Ball::level_7() { /// CENTRE OPEN
    _lcd -> drawRect(8, 1, 68, 5, FILL_BLACK);
    _lcd -> drawRect(8, 19, 68, 5, FILL_BLACK);
    _lcd -> drawRect(8, 1, 18, 24, FILL_BLACK);
    _lcd -> drawRect(58, 1, 18, 24, FILL_BLACK);
}
void Ball::level_8() { /// TOP LEFT CORNER OPEN = level3 + level6
    level_3();
    level_6();
}
void Ball::level_9() { /// TOP RIGHT CORNER OPEN = level2 + level6
    level_2();
    level_6();
}
void Ball::level_10() { /// BOTTOM CORNERS OPEN = level4 + level 5
    level_4();
    level_5();
}
void Ball::check_level_1(int x, int y) {
    // check if ball is within goal (ball must not hit poles hence, dimensions
    // are smaller i.e. 8-78 -> 10-76 and 24-3 -> 24-5
    if (x >= 10 && x <= 76 && y <= 24 && y >= 5) {
        _goal = true;
    }
}
void Ball::check_level_2(int x, int y) {
    if (x >= 44 && x <= 76 && y <= 24 && y >= 5) {
        _goal = true;
    }
}
void Ball::check_level_3(int x, int y) {
    if (x >= 10 && x <= 44 && y <= 24 && y >= 5) {
        _goal = true;
    }
}
void Ball::check_level_4(int x, int y) {
    // either left or right
    if ((x >= 10 && x <= 29) || (x >= 55 && x <= 76)) {
        if (y <= 24 && y >= 5) {
            _goal = true;
        }
    }
}
void Ball::check_level_5(int x, int y) {
    if (x >= 10 && x <= 76 && y <= 24 && y >= 12) {
        _goal = true;
    }
}
void Ball::check_level_6(int x, int y) {
    if (x >= 10 && x <= 76 && y <= 12 && y >= 5) {
        _goal = true;
    }
}
void Ball::check_level_7(int x, int y) {
    if (x >= 26 && x <= 56 && y <= 19 && y >= 6) {
        _goal = true;
    }
}
void Ball::check_level_8(int x, int y) {
    // x conditons for level 3, y conditions for level 6
    if (x >= 10 && x <= 40 && y <= 12 && y >= 5) {
        _goal = true;
    }
}
void Ball::check_level_9(int x, int y) {
    // x conditons for level 2, y conditions for level 6
    if (x >= 44 && x <= 76 && y <= 12 && y >= 5) {
        _goal = true;
    }
}
void Ball::check_level_10(int x, int y) {
    // x conditons for level 4, y conditions for level 5
    // either left or right
    if ((x >= 10 && x <= 30) || (x >= 54 && x <= 76)) {
        if (y <= 24 && y >= 12) {
            _goal = true;
        }
    }
}
/*
void Ball::level_loop() {
    displayBackground();
    level_2();
    _lcd -> refresh();
    wait(5);
    _lcd -> clear();
      displayBackground();
    level_3();
    _lcd -> refresh();
    wait(5);
    _lcd -> clear();
     displayBackground();
    level_4();
    _lcd -> refresh();
    wait(5);
    _lcd -> clear();
    displayBackground();
    level_5();
    _lcd -> refresh();
    wait(5);
    _lcd -> clear();
    displayBackground();
    level_6();
    _lcd -> refresh();
    wait(5);
    _lcd ->clear();
    displayBackground();
    level_7();
    _lcd -> refresh();
    wait(5);
    _lcd -> clear();
    displayBackground();
    level_8();
    _lcd -> refresh();
    wait(5);
    _lcd -> clear();
    displayBackground();
    level_9();
    _lcd -> refresh();
    wait(5);
    _lcd -> clear();
    displayBackground();
    level_10();
} 
*/