#ifndef BALL_TEST_H
#define BALL_TEST_H

N5110 lcd2;
Ball ball1(lcd2);
Ball ball2(lcd2);
Ball ball3(lcd2);

bool success_flag = true;

/**
 * \brief Check that Ball object goes to correct position when moved
 * \returns true if all the tests passed
 */
bool Ball_test_movement() {
    success_flag = true;
    ball1.init();

    Vector2D initial_pos = ball1.get_position();
    printf("%f, %f\n", initial_pos.x, initial_pos.y);

    ball1.drawBall(5, 5, 2);
    Vector2D read_pos_1 = ball1.get_position();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);

    // Fail the test if the initial position is wrong
    if (initial_pos.x != 42 || initial_pos.y != 49) {
        success_flag = false;
    }

    // Fail the test if the final position is wrong
    if (read_pos_1.x != 5 || read_pos_1.y != 5) {
        success_flag = false;
    }
    return success_flag;
}

/**
 * \brief Check that Ball object updates level correctly
 * \returns true if all the tests passed
 */
bool Ball_test_level() {
    success_flag = true;
    ball2.init();
    int initial_level = ball2.get_level();
    printf("%d\n", initial_level);

    ball2.set_level(5);
    int read_level_1 = ball2.get_level();
    printf("%d\n", read_level_1);

    ball2.set_level(10);
    int read_level_2 = ball2.get_level();
    printf("%d\n", read_level_2);

    if (initial_level != 1) { success_flag = false; }
    if (read_level_1 != 5) { success_flag = false; }
    if (read_level_2 != 10) { success_flag = false; }
    return success_flag;
}

// Tests for each level 

void test_level_1() {
    // Goal Case
    if (!ball3.isGoal(1, 42, 12)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(1, 0, 0)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 1 failed");
    }
}
void test_level_2() {
    // Goal Case
    if (!ball3.isGoal(2, 60, 12)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(2, 24, 12)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 2 failed");
    }
}
void test_level_3() {
    // Goal Case
    if (!ball3.isGoal(3, 24, 12)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(3, 60, 12)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 3 failed");
    }

}
void test_level_4() {
    // Goal Case left
    if (!ball3.isGoal(4, 15, 12)) {
        success_flag = false;
    }
    // Goal Case right 
    if (!ball3.isGoal(4, 60, 12)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(4, 30, 12)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 4 failed");
    }
}
void test_level_5() {
    // Goal Case
    if (!ball3.isGoal(5, 15, 15)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(5, 15, 7)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 5 failed");
    }
}
void test_level_6() {
    // Goal Case
    if (!ball3.isGoal(6, 15, 7)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(6, 15, 15)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 6 failed");
    }
}
void test_level_7() {
    // Goal Case
    if (!ball3.isGoal(7, 42, 12)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(7, 10, 12)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 7 failed");
    }
}
void test_level_8() {
    // Goal Case
    if (!ball3.isGoal(8, 22, 7)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(8, 60, 7)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 8 failed");
    }
}
void test_level_9() {
    // Goal Case
    if (!ball3.isGoal(9, 60, 7)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(9, 22, 7)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 9 failed");
    }
}
void test_level_10() {
    // Goal Case left
    if (!ball3.isGoal(10, 20, 16)) {
        success_flag = false;
    }
    // Goal Case right
    if (!ball3.isGoal(10, 60, 16)) {
        success_flag = false;
    }
    // Miss Case
    if (ball3.isGoal(10, 42, 16)) {
        success_flag = false;
    }
    if (!success_flag) {
        printf(" Level 10 failed");
    }
}
/**
 * \brief Check that Ball object can deteremine if goal is scored or missed
 * \returns true if all the tests passed
 */
bool Ball_test_goal() {
    success_flag = true;
    test_level_1();
    test_level_2();
    test_level_3();
    test_level_4();
    test_level_5();
    test_level_6();
    test_level_7();
    test_level_8();
    test_level_9();
    test_level_10();
    return success_flag;
}
#endif