/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:ZIYI CHEN
Username: ml17z4c
Student ID Number:201214999
Date:may 2019
*/


#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Eng.h"


//defination
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Eng gameset;
Gamepad gamepad;
Direction d;

void init();

void renderSnake();

void welcome();

void restart();




int main()
{

    init();
    welcome();

    bool started = false;
    while (1) {

        if(gamepad.check_event(Gamepad::START_PRESSED) == true) {
            started = true;
        }
        if(started) {
            gameset.userinput(gamepad);
            gameset.update(gamepad);
            renderSnake();
            if (gameset.getGameOver()) { 
                gameset.score(lcd);
                restart();
            }
        }

    }
}

void init()
{
    
    gameset.init();
    lcd.init();
    lcd.setContrast(0.5);
    gamepad.init();


}
void welcome()
{


    lcd.printString("   snake  ",0,1);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();

    while ( gamepad.check_event(Gamepad::START_PRESSED) == false) {
        gamepad.leds_on();
        wait(0.1);
        gamepad.leds_off();
        wait(0.1);
    }
    wait(0.1);

}



void restart()
{
 
    gameset.init();      
}

void renderSnake()
{
    lcd.clear();
    gameset.draw(lcd);
    lcd.refresh();
    wait(0.2); 

}



