#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** The Game class
* @brief the functions of game roles
* @author ZIYI CHEN
* @date May 2019
*/

class Game
{
public:

    /**Constructor*/
    Game();

    /**Destructor*/
    ~Game();

 /** init function
    * @param inital starting coordinate of snake head.
    */
    void init(int x, int y);
    /** Updates coordinate of snake
    * @param the joystick'direction
    */
    void update(Direction d);
    
    /** Gets snake length
    * @return the value of snake length
    */
    int getLength();
    
     /** add snake length by 1 */
    void grow();
    
        
    /** Gets x coordinate of the snake
    * @param the position of snake in x coorinate
    * @return value of _x[now]
    */
    int xcoordinate(int now);
    
    /** Gets y coordinate of the snake
    * @param the position of snake in y coorinate
    * @return value of _y[now]
    */
    int ycoordinate(int now);
    /**  the previous direction of snake*/
    char Previous_direction;
    

    int _length;



    /**the _y and _y array*/
    int _x[4032];
    int _y[4032];



};
