#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Game.h"
#include "Food.h"


/** The Game class
* @brief Handles all failure states and game drawing
* @author ZIYI CHEN
* @date May 2019
*/
class Eng
{

public:

    /**Constructor*/
    Eng();
    
    /**Destructor*/
    ~Eng();
    
    /** The init function   */
    void init();
    
    /**load map function
    *@param drow map on lcd
    */

    void userinput(Gamepad &pad);
    
   /**draw the game picture
    *@@param use LCD to draw
    */
    void draw(N5110 &lcd);
    
    /**draw the game over picture
    *@@param give score and wait 5 seconds to play again
    */
    void score(N5110 &lcd);
    /** Updates game state
    * @param check and update the game state
    */
    void update(Gamepad &pad);




   
  /** Gets score
    * @return score
    */
 
    float getScore();
    
    /** Gets gameover
    * @return ifgameOver
    */
    bool getGameOver();




  /** Gets  checkFood
    * @return value of checkFood
    */
    bool checkFood();
    /** extand the snake function
    * @return snake grow 
    */
    void growSnake();
     /** check weather the snake dead
    * @return snake dead game end
    */
    void dead();
    
    /** Gets  _gameOver
    * @return value of _gameOver
    */
   bool _gameOver;
   
    /**some variables used to save score direction, map, food and others*/
    int _score;
    Direction _d;
    int snake1[84][48];
    Game dSnake; 
    Food _noodles; 

};