/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Caiwenjing Liu
Username:ml16c5l
Student ID Number: 201165261
Date: 09/04/2019
*/

///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "CopterEngine.h"





#define WALL_SIZE 3
#define COPTER_WIDTH 15
#define COPTER_HEIGHT 10
#define COPTER_SPEED 1
/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
CopterEngine copter;
extern N5110 lcd;








///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();



///////////// functions ////////////////


int main()
{
   
    int fps = 8;  // frames per second
    init();     // initialise and then display welcome screen...
    welcome();  // waiting for the user to start
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period
    
    // game loop - read input, update the game state and render the display
      while (1) {
  
   lcd.clear(); 
   
                 int a = copter.GameOver();
                 if(a == 1)
                 {   a=0;
                     lcd.clear();
                     lcd.printString("GAME OVER", 10,1);
                     lcd.refresh();
                     int h=0;
                     for(h=1; h<=500; h++){
                     pad.tone(h,0.5);
                     }
                     
                     wait(1.0);
                     lcd.printString("PRESS BACK" ,13,3);
                     lcd.printString("RESTART",20,4);
                     lcd.refresh();
                       while (pad.check_event(Gamepad::BACK_PRESSED)== false) 
                       {
                                  
                                  pad.leds_on();
                                  wait(0.1);
                       }
                       
                        init();
                        welcome();
                        
                        render();
                        wait(1.0f/fps);
                 }
    
        copter.read_input(pad);
        copter.update(pad);
    
        render();
        wait(1.0f/fps);
        
    }
} 

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
   copter.init(COPTER_WIDTH,COPTER_HEIGHT,WALL_SIZE,COPTER_SPEED);

}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
   lcd.clear();  
  copter.draw(lcd);
    lcd.refresh();
}


// simple splash screen displayed on start-up
void welcome() {
    
    lcd.clear();  
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
       
    pad.leds_on();
    lcd.drawLine(25,1,26,1,1);
    
    lcd.drawLine(23,2,27,2,1);
    lcd.drawLine(39,2,39,2,1);
    
    lcd.drawLine(22,3,28,3,1);
    lcd.drawLine(38,3,39,3,1);
    
    lcd.drawLine(21,4,23,4,1);
    lcd.drawLine(27,4,28,4,1);
    lcd.drawLine(38,4,38,4,1);
    
    lcd.drawLine(21,5,22,5,1);
    lcd.drawLine(38,5,38,5,1);
    lcd.drawLine(50,5,51,5,1);
    
    lcd.drawLine(20,6,22,6,1);
    lcd.drawLine(27,6,29,6,1);
    lcd.drawLine(31,6,34,6,1);
    lcd.drawLine(36,6,40,6,1);
    lcd.drawLine(42,6,45,6,1);
    lcd.drawLine(49,6,52,6,1);
    
    lcd.drawLine(20,7,21,7,1);
    lcd.drawLine(26,7,27,7,1);
    lcd.drawLine(29,7,31,7,1);
    lcd.drawLine(35,7,35,7,1);
    lcd.drawLine(37,7,38,7,1);
    lcd.drawLine(41,7,42,7,1);
    lcd.drawLine(45,7,49,7,1);
    lcd.drawLine(53,7,53,7,1);
    
    lcd.drawLine(20,8,21,8,1);
    lcd.drawLine(26,8,26,8,1);
    lcd.drawLine(30,8,31,8,1);
    lcd.drawLine(35,8,35,8,1);
    lcd.drawLine(37,8,37,8,1);
    lcd.drawLine(41,8,41,8,1);
    lcd.drawLine(46,8,46,8,1);
    lcd.drawLine(48,8,48,8,1);
    
    lcd.drawLine(20,9,22,9,1);
    lcd.drawLine(26,9,26,9,1);
    lcd.drawLine(30,9,31,9,1);
    lcd.drawLine(34,9,35,9,1);
    lcd.drawLine(37,9,37,9,1);
    lcd.drawLine(41,9,45,9,1);
    lcd.drawLine(48,9,48,9,1);
    
    lcd.drawLine(21,10,22,10,1);
    lcd.drawLine(26,10,27,10,1);
    lcd.drawLine(29,10,34,10,1);
    lcd.drawLine(37,10,37,10,1);
    lcd.drawLine(41,10,42,10,1);
    lcd.drawLine(48,10,48,10,1);
    
    lcd.drawLine(22,11,22,11,1);
    lcd.drawLine(26,11,29,11,1);
    lcd.drawLine(31,11,32,11,1);
    lcd.drawLine(37,11,37,11,1);
    lcd.drawLine(42,11,43,11,1);
    lcd.drawLine(46,11,46,11,1);
    lcd.drawLine(48,11,48,11,1);

    lcd.drawLine(22,12,26,12,1);
    lcd.drawLine(31,12,31,12,1);
    lcd.drawLine(37,12,37,12,1);
    lcd.drawLine(43,12,45,12,1);
    lcd.drawLine(47,12,48,12,1);
    
    lcd.drawLine(24,13,25,13,1);
    lcd.drawLine(31,13,31,13,1);
    lcd.drawLine(37,13,38,13,1);
    lcd.drawLine(47,13,47,13,1);
    
    lcd.drawLine(31,14,31,14,1);
    lcd.drawLine(38,14,39,14,1);
    
    lcd.drawLine(31,15,31,15,1);
    lcd.drawLine(30,16,31,16,1);
    lcd.drawLine(29,17,30,17,1);
    lcd.drawLine(29,18,29,18,1);
    
    lcd.printString("Press START ",8,3);
    lcd.printString("to Start ",20,5);

  
     lcd.refresh();
        pad.leds_on();
        wait(0.2);
        pad.tone(50,0.1);
        wait(0.2);
        pad.tone(100,0.01);
        wait(0.2);
        pad.tone(500,0.1);
        wait(0.2);
        pad.tone(700,0.01);
        wait(0.2);
        pad.tone(500,0.1);
        wait(0.2);
        pad.tone(100,0.01);
        wait(0.2);
        pad.tone(50,0.1);
        wait(0.2);
        pad.tone(100,0.01);
        wait(0.2);
        pad.tone(500,0.1);
        wait(0.2);
        pad.tone(700,0.1);
        wait(0.2);
        pad.tone(500,0.1);
        wait(0.2);
        pad.tone(100,0.1);
        wait(0.2);
        pad.tone(50,0.1);
    }
    
 
}


    