/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Caiwenjing Liu
Username:ml16c5l
Student ID Number: 201165261
Date: 11/04/2019
*/

#ifndef WALL_H
#define WALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Copter.h"


/** Wall Class
@author Caiwenjing Liu, University of Leeds
@brief the code of copter for the CopterGame
@date 11/04/2019
*/

class Wall
{
public:
     /** Constructor */
    Wall();
    /** Destructor */
    ~Wall();
    
     /** initialise wall parameters
     * @param the value of size and speed.
     */
    void init(int size,int speed);
    /** the pic of the wall
     * @param to draw the wall on LCD
     */
    void draw(N5110 &lcd);
    /** Update wall again 
     * @param show the wall again 
     */
    void update();
    /// accessors and mutators
    
    /** set the velocity 
     * @param set the value of velocity
     */  
    void set_velocity(Vector2D v);
    Vector2D get_velocity();
    Vector2D get_pos();
    
    /** get the velocity
     * @return the value of velocity
     */
    void set_pos(Vector2D p);

private:

    Vector2D _velocity;
    int _size;
    /** get the velocity
     * @return the value of velocity
     */
    int _x;
    /** get the velocity
     * @return the value of velocity
     */
    int _y;




};
#endif