/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Caiwenjing Liu
Username:ml16c5l
Student ID Number: 201165261
Date: 24/04/2019
*/



#ifndef COPTERENGINE_H
#define COPTERENGINE_H


#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Copter.h"
#include "Wall.h"


// gap from edge of screen
#define GAP 4


/** CopterEngine Class
@author Caiwenjing Liu, University of Leeds
@brief the code of copter for the CopterGame
@date 11/04/2019
*/

class CopterEngine
{

public:
    /** Constructor */
    CopterEngine();

    /** Destructor */
    ~CopterEngine();


    /** initialise Copter and wall parameters
     * @param the value of Copter_width,Copter_height,wall_size,speed.
     */
    void init(int Copter_width,int Copter_height,int wall_size,int speed);

    /** get the input of the user
     * @param for user to input
     * @return input from the user
     */
    void read_input(Gamepad &pad);


    /** update the gamepad
     * @param update the gamepad when users start the game
     * @return update the gamepad
     */
    void update(Gamepad &pad);


    /** draw all those things on the screen, which are walls and the copter
     * @param draw wall copter and so on defined in classes
     * @return the wall copter 
     */
    void draw(N5110 &lcd);

    /** get the state of which the game is finished or not
     * @param the end when the game is over
     * @return current state of the end when the game is over
     */
    int GameOver();
    
    /** int the game over
     * @param the end when the game is over
     * @return game over
     */
    int gameover;
   /** int the end of the game 
     * @param the end when the game is over
     * @return game over
     */
    int z;

private:


    // initiate all classes
    Copter _p1;
    Wall _wall;

    /** Check the screen edgess
     * @param check edge of the copter
     */
    void check_wall_edge(Gamepad &pad);

    /** Check the wall and  Copter  edges
     * @param check the edge of the copter when it collides with any wall
     */
    void check_WallCopter_edges(Gamepad &pad);

    /** Check the goal
      * @param Check how much score have the user earned
      */
    void check_goal(Gamepad &pad);
    /** Print scores on LCD
      * @param Get the score and use sprint function to print it to LCD
      */
    void print_scores(N5110 &lcd);

    /** int the width of the copter
         * @return the wicth of the copter
         */
    int _Copter_width;
    /** int the height of the copter
         * @return the height of the copter
         */
    int _Copter_height;
    /** int the speed of the copter
         * @return the speed of the copter
         */
    int _speed;

    /** int the position for x of the copter
         * @return the position for x of the copter
         */
    int _posx;
    
    /** int the size of wall
         * @return the size of wall
         */
    int _wall_size;



    Direction _d;
    float _mag;

};




#endif
