  /*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Caiwenjing Liu
Username:ml16c5l
Student ID Number: 201165261
Date: 24/04/2019
*/


 
 #include "CopterEngine.h"
CopterEngine::CopterEngine()
{

}

CopterEngine::~CopterEngine()
{

}



void CopterEngine::init(int Copter_width,int Copter_height,int wall_size,int speed)
{
    // initialise the game parameters
    _Copter_width = Copter_width;
    _Copter_height = Copter_height;
    _wall_size = wall_size;
    _speed = speed; 

    // x position on screen 
    _posx = GAP;
  
    // set the initial position for the copter and walls 
    _p1.init(_posx,_Copter_height,_Copter_width);
    _wall.init(_wall_size,_speed);
    }
    
    
void CopterEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}


void CopterEngine::draw(N5110 &lcd)
{

    // draw the Copter
    _p1.draw(lcd);
    // draw the walls on the screen 
    _wall.draw(lcd);
    
    //print scores on the screen 
     print_scores(lcd);

}

void CopterEngine::update(Gamepad &pad)
{
    //update the real time x and y coordinates of copter and walls and scores on LCD 
    check_goal(pad);    
    _p1.update(_d,_mag);
    _wall.update();
    
    check_wall_edge(pad);
    check_WallCopter_edges(pad);
    
}


void CopterEngine::check_wall_edge(Gamepad &pad)
{
   
    // read current ball attributes
    Vector2D p1_pos = _p1.get_pos();

   
    // check if hit top wall
   
    if (p1_pos.y <= 0) {  
        pad.tone(500.0,0.001);
    }
    else if (p1_pos.y  >= (HEIGHT) ) { 
    
        pad.tone(500.0,0.01);
        pad.tone(50.0,0.01);
    }


}




void CopterEngine::check_WallCopter_edges(Gamepad &pad)
{
    // before the collosion the game isn't over 
    gameover = 0;
   // initialise the score  
   int p1_score = _p1.get_score();
   
    // read current Wall attributes
    Vector2D wall_pos = _wall.get_pos();
 
    // check p1(Copter) first
    Vector2D p1_pos = _p1.get_pos();

  
    // see if Copter has hit the Wall by checking for overlaps
    
 
    // overlaps for Wall
    if (
        //wall1
        (wall_pos.y <= p1_pos.y ) && //top   
        (wall_pos.y + 15>= p1_pos.y  )&&//bottom 
        (wall_pos.x - 50<= p1_pos.x +14)&& //left
        (wall_pos.x - 45>= p1_pos.x)//right
    ){     
         pad.tone(50,0.1);
         wait(0.02);
         
         // copter returns to the original position 
         _p1.init(_posx,_Copter_height,_Copter_width);
            
        pad.tone(100,0.1);
       
       //the copter touches the wall
        gameover = 1;
          
    }
    
    if(
    //wall2
        (wall_pos.y + 5<=p1_pos.y)&&
        (wall_pos.y + 29>= p1_pos.y  )&&
        (wall_pos.x - 20<= p1_pos.x +14)&&
        (wall_pos.x - 15>= p1_pos.x)
    ){     
         pad.tone(50,0.1);
         wait(0.02);
         
         // copter returns to the original position 
         _p1.init(_posx,_Copter_height,_Copter_width);
            
        pad.tone(100,0.1);
       
       //the copter touches the wall
        gameover = 1;
        } 
    if(
    //wall3
        (wall_pos.y + 23<=p1_pos.y)&&
        (wall_pos.y + 50>= p1_pos.y  )&&
        (wall_pos.x + 10<= p1_pos.x +14)&&
        (wall_pos.x + 15>= p1_pos.x)
    ){     
         pad.tone(50,0.1);
         wait(0.02);
         
         // copter returns to the original position 
         _p1.init(_posx,_Copter_height,_Copter_width);
            
        pad.tone(100,0.1);
       
       //the copter touches the wall
        gameover = 1;
        } 
  
  if(
    //wall4
        (wall_pos.y + 28<=p1_pos.y)&&
        (wall_pos.y + 55>= p1_pos.y  )&&
        (wall_pos.x - 60<= p1_pos.x +14)&&
        (wall_pos.x - 55>= p1_pos.x)
    ){     
         pad.tone(50,0.1);
         wait(0.02);
         
         // copter returns to the original position 
         _p1.init(_posx,_Copter_height,_Copter_width);
            
        pad.tone(100,0.1);
       
       //the copter touches the wall
        gameover = 1;
        } 
  
  if(
    //wall5
        (wall_pos.y <=p1_pos.y)&&
        (wall_pos.y + 10>= p1_pos.y  )&&
        (wall_pos.x + 10<= p1_pos.x +14)&&
        (wall_pos.x + 15>= p1_pos.x)
    ){     
         pad.tone(50,0.1);
         wait(0.02);
         
         // copter returns to the original position 
         _p1.init(_posx,_Copter_height,_Copter_width);
            
        pad.tone(100,0.1);
       
       //the copter touches the wall
        gameover = 1;
        } 
  
    }
    
    
int CopterEngine ::GameOver()
{
     z = gameover;
     return z;
     }


void CopterEngine::check_goal(Gamepad &pad)
{
    
    
   // read current Copter and Walls attributes
    Vector2D p1_pos = _p1.get_pos();
    Vector2D wall_pos = _wall.get_pos();

    if ( 
        (wall_pos.x - 50 == p1_pos.x)||
        (wall_pos.x - 20 == p1_pos.x)||
        (wall_pos.x + 10 == p1_pos.x)||
        (wall_pos.x - 60 == p1_pos.x)
    )
     {
        _p1.add_score();
        pad.tone(1500.0,0.1);
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
    }


}


void CopterEngine::print_scores(N5110 &lcd)
{
    // get scores from The copter class
    
   int p1_score = _p1.get_score();
    
        
    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%1d",p1_score);
    lcd.printString(buffer1,0 ,1);  

}

