/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Caiwenjing Liu
Username:ml16c5l
Student ID Number: 201165261
Date: 11/04/2019
*/

#ifndef COPTER_H
#define COPTER_H


#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Copter Class
@author Caiwenjing Liu, University of Leeds
@brief the code of copter for the CopterGame
@date 11/04/2019
*/

class Copter
{
    public :       
        /** Constructor */
        Copter();
       
        /** Destructor */
        ~Copter();
       
        /** initialise Copter parameters
         * @param the value of copter height, copter width and x coordinates
         * @return the value of copter height, copter width and x coordinates
         */
        void init(int x,int height,int width);
       
        /** draw the copter on LCD
        * @param using drawsprite method to draw the copter on LCD
        * @return the copter on LCD
        */
        void draw(N5110 &lcd);
        
        
        /** update the LCD screen 
         * @param update the LCD screen when user interact with the pad
        * @return update the LCD screen
        */
        void update ( Direction d, float mag );
     
    
       /** Set the score
        * @param the value of the score (int)
        * @return the value of the score
        */
        void add_score();      
      
      
        /** Get the score
         * @param for the current score
         * @return the current score
         */
        int get_score();
       
       
        Vector2D get_pos();
 
   private:
         /** int the height
         * @return the height
         */
        int _height;
         /** int the width
         * @return the width
         */
        int _width;
         /** int the position of x
         * @return the position of x
         */
        int _x;
         /** int the position of y
         * @return the position of y
         */
        int _y;
         /** int the speed of copter
         * @return the speed of copter
         */
        int _speed;
         /** int the score
         * @return the score
         */
        int _score;

       };


#endif