#include "Objects.h"

// nothing doing in the constructor and destructor
Objects::Objects()
{

}

Objects::~Objects()
{

}


void Objects::init(int size,int speed)
{
    _size = size;

    _x_edge = WIDTH -  _size/2; // Edge of horizontal
    _y_edge = HEIGHT - _size/2; // Edge of vertical
    
    
    _x = rand() % _x_edge; // Generate random position on the screen - 0 to the edge
    _y = rand() % _y_edge; // Generate random position on the screen - 0 to the edge

    srand(time(NULL));
    int direction = rand() % 4; // randomise initial direction. 

    // 4 possibilities. Get random modulo and set velocities accordingly
    if (direction == 0) {
        _velocity.x = speed;
        _velocity.y = speed;
    } else if (direction == 1) {
        _velocity.x = speed;
        _velocity.y = -speed;
    } else if (direction == 2) {
        _velocity.x = speed;
        _velocity.y = speed;
    } else {
        _velocity.x = -speed;
        _velocity.y = -speed;
    }
}

void Objects::draw(N5110 &lcd)
{
    lcd.drawCircle(_x,_y,_size,FILL_BLACK);  // x,y,radius,black fill
}

void Objects::update()
{
    _x += _velocity.x;
    _y += _velocity.y;
}

void Objects::set_velocity(Vector2D v)
{
    _velocity.x = v.x;
    _velocity.y = v.y;
}

Vector2D Objects::get_velocity()
{
    Vector2D v = {_velocity.x,_velocity.y};
    return v;
}

/**
*   This method will be used to set the postion of the objects.
*   @author Oliver Luong
*   @date 22/04/2019
*/
void Objects::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}


/**
*   This method will be used to return the position when called.
*   @author Oliver Luong
*   @date 22/04/2019
*/
Vector2D Objects::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}