#ifndef PLAYER_H
#define PLAYER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Player Class

@brief Controls the player in the Dodge game 

@brief Revisions 1.0


@author Oliver Luong, University of Leeds
@date 22/04/2019
*/ 
class Player
{
public:
    /** Contructor / Destructor */
    Player();
    ~Player();
    
// Methods
    /**
    This method will be used to initialise the player variables.
    Saves global variable values to local variables.
    @param player_height fetched from dodge engine.
    @param player_width ftechedd from dodge engine.
    */
    void init(int player_height,int player_width);
    
    /**
    This method will be used to store the sprite for player and draw it
    onto the LCD.
    */
    void draw(N5110 &lcd);
    
    /**
    This method will be used to update the positioning of 
    the player in one of 8 directions.
    @param d fectches the direction of thhe joystick from dodge engine.
    @param mag fetches the magintude of the joystick from dodge engine.
    */
    void update(Direction d, float mag);
    
    /**
    This method will be used to save the position of the player into p and retuns the position of the player.
    */
    Vector2D get_pos();

private:
// Variables
    int _player_height;
    int _player_width;
    int _x;
    int _y;
    int _speed;

};
#endif