#include "Player.h"

// nothing doing in the constructor and destructor
Player::Player()
{

}

Player::~Player()
{

}

void Player::init(int player_height,int player_width)
{
    // Initialise at the centre
    
    _x = HEIGHT/2 - player_height/2;
    _y = WIDTH/2 - player_width/2;
    
    _player_height = player_height;
    _player_width = player_width;
    
    _speed = 1;  // default speed
}

void Player::draw(N5110 &lcd)
{
    int Player_sprite[14][14] = {
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,0,0,0,1,1,0,0,0,1,1,1},
    {1,1,1,1,0,0,1,1,0,0,1,1,1,1},
    {1,0,1,1,1,0,1,1,0,1,1,1,0,1},
    {1,0,0,1,1,1,1,1,1,1,1,0,0,1},
    {1,0,0,0,1,1,1,1,1,1,0,0,0,1},
    {1,0,0,0,0,1,1,1,1,0,0,0,0,1},
    {1,0,0,0,0,1,1,1,1,0,0,0,0,1},
    {1,0,0,0,1,1,1,1,1,1,0,0,0,1},
    {1,0,0,1,1,1,1,1,1,1,1,0,0,1},
    {1,0,1,1,1,0,1,1,0,1,1,1,0,1},
    {1,1,1,1,0,0,1,1,0,0,1,1,1,1},
    {1,1,1,0,0,0,1,1,0,0,0,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    };
    
    // Instantiate the Bitmap object using the data above
    lcd.drawSprite(_x, _y, _player_height, _player_width,(int *)Player_sprite);
}

void Player::update(Direction d, float mag)
{
    _speed = int(mag*10.0f);  // scale is arbitrary, could be changed in future

    // update y value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == N) {
        _y-=_speed; // updates the speed in directions depending on joystick position, d.
    } else if (d == NE) {
        _y-=_speed;
        _x+=_speed;
    } else if (d == E) {
        _x+=_speed;
    } else if (d == SE) {
        _y+=_speed;
        _x+=_speed;
    } else if (d == S) {
        _y+=_speed;
    } else if (d == SW) {
        _y+=_speed;
        _x-=_speed;
    } else if (d == W) {
        _x-=_speed;
    } else if (d == NW) {
        _y-=_speed;
        _x-=_speed;
    }

    // check the y origin to ensure that the player doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > HEIGHT - _player_height - 1) {
        _y = HEIGHT - _player_height - 1;
    }
    
    // check the x origin to ensure that the player doesn't go off screen
    if (_x < 1) {
        _x = 1;
    }
    if (_x > WIDTH - _player_width - 1) {
        _x = WIDTH - _player_width - 1;
    }
}

/**
*   This method will be used to retun the position of the player.
*   @author Oliver Luong
*   @date 22/04/2019
*/
Vector2D Player::get_pos() {
    Vector2D p = {_x,_y};
    return p;    
}
