#ifndef Objects_H
#define Objects_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Player.h"

/** Objects Class

@brief Controls the objects in the Dodge game 

@brief Revisions 1.0


@author Oliver Luong, University of Leeds
@date 22/04/2019
*/ 
class Objects
{

public:
    /** Contructor / Destructor */
    Objects();
    ~Objects();
    
// Methods
    /**
    This method will be used to initialise the objects variables.
    Saves global variables to local variables.
    @param size fetched from the dodge engine.
    @param speed fetched from the dodge engine.
    */
    void init(int size,int speed);
    
    /**
    This method will be used to draw the objects to the LCD.
    */
    void draw(N5110 &lcd);
    
    /**
    This method will be used to update the objects position.
    */
    void update();
    
    /**
    This method will be used to set the velocity of the objects.
    @param v velocity fectched from get_velocity
    */
    void set_velocity(Vector2D v);
    
    /**
    This method will be used to return the velocity when called.
    */
    Vector2D get_velocity();
    
    
    Vector2D get_pos();
    
    /**
    This method will be used to set the postion of the objects.
    @param p, stores the x and y component of postion.
    */
    void set_pos(Vector2D p);
    
private:

    Vector2D _velocity;
    
// Variables
    int _size;
    int _x;
    int _y;
    int _x_edge;
    int _y_edge;
};
#endif