#ifndef INSTRUCTION_H
#define INSTRUCTION_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Instructions Class

@brief Stores the instruction message and then writes it to the LCD.

@brief Revisions 1.0


@author Oliver Luong, University of Leeds
@date 06/05/2019
*/ 

class Instruction
{
public:
    /** Contructor / Destructor */
    Instruction();
    ~Instruction();
    
// Methods
    /**
    This method will be used to initialise the value y.
    */
    void init();
    
    /**
    This method will be used to read the jostick and then to change the value of y.
    */
    void write(N5110 &lcd);
    
    /**
    This method will be used to write to the lcd.
    */
    void control(Gamepad &pad);
    
private:
    Direction d;
    
// Variables
    int y;
    int max_length;

};

#endif