#ifndef DODGENGINE_H
#define DODGEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Objects.h"
#include "Player.h"
#include "Health_Kit.h"

/** DodgeEngine Class

@brief Controls the functionality of the Dodge game .
@breif Controls when the objects are generated into the game and the conditions when the objects collide with the walls
@brief also when the player collides with the objects and health pack what should be done to the lives and the output.  

@brief Revisions 1.0


@author Oliver Luong, University of Leeds
@date 22/04/2019
*/ 


class DodgeEngine
{

public:
    /** Contructor / Destructor */
    DodgeEngine();
    ~DodgeEngine();
    
    /** 
    This method will be used to set the global variables to local variable
    @author Oliver Luong
    @param player_width fetches the initialised player width from main.
    @param player_height fetches the initialised player height from main.
    @param objects_size fetches the initialised object size from main.
    @param speed fetches the initialised speed from main.
    @param lives fetches the initialised lives from main.
    @param kit_size fetches the initialised kit size from main.
    */
    void init(int player_width,int player_height,int objetcs_size,int speed,int lives, int kit_size);
    
    /** Fetch direction and magintude of the joystick and save to local variables. */
    void read_input(Gamepad &pad);
    
    /**
    This method will be used to update the direction of the player 
    and call the methods to check objects for collisions/overlaps
    */
    void update(Gamepad &pad);
    
    /** Drawing the player, objects and the health kit to the LCD */
    void draw(N5110 &lcd);
    
    /**
    This method will be used to return the value of lose when called
    */
    int get_lose();
    
    /**
    This method will be used to store the time value to a local variable.
    @param time fetched from main.
    */
    void time(float time);
    
private:

// Methods
    
    /**
    This method will be used to check for object 1 collisions to the wall
    and reposition the objects as to bounce off the walls.
    */
    void check_wall_collision1(Gamepad &pad);
    
    /**
    This method will be used to check for object 2 collisions to the wall
    and reposition the objects as to bounce off the walls.
    */
    void check_wall_collision2(Gamepad &pad);
    
    /**
    This method will be used to check for object 3 collisions to the wall
    and reposition the objects as to bounce off the walls.
    */
    void check_wall_collision3(Gamepad &pad);
    
    /**
    This method will be used to check for object 4 collisions to the wall
    and reposition the objects as to bounce off the walls.
    */
    void check_wall_collision4(Gamepad &pad);
    
    /**
    This method will be used to check for player collisions with object 1
    and calls on the player_hit method if condition is met.
    */
    void check_player_collisions1(Gamepad &pad);
    
    /**
    This method will be used to check for player collisions with object 2
    and calls on the player_hit method if condition is met.
    */
    void check_player_collisions2(Gamepad &pad);
    
    /**
    This method will be used to check for player collisions with object 3
    and calls on the player_hit method if condition is met.
    */
    void check_player_collisions3(Gamepad &pad);
    
    /**
    This method will be used to check for player collisions with object 4
    and calls on the player_hit method if condition is met.
    */
    void check_player_collisions4(Gamepad &pad);
    
    /**
    This method will be used to check for player collisions with health kit
    and sets collect to true.
    */
    void check_player_health_kit_collison(Gamepad &pad); 
    
    /**
    This method is used to increase the lives variable value by 1 if 
    the conditions are met and with user input.
    */
    void life_up(Gamepad &pad);
    
    /**
    This method will be used to display the players lives using
    the LEDs.
    */
    void life_leds(Gamepad &pad);
    
    /**
    This method is used to reduce a life if the condition is met.
    */
    void player_hit(Gamepad &pad);
    
    /**
    This method will be used to print the lives and time to LCD
    */
    void print_lives_time(N5110 &lcd);
    
// Objects
    Player _player;
    Objects _objects1;
    Objects _objects2;
    Objects _objects3;
    Objects _objects4;
    Health_Kit _health_kit;
    
    
// Vairables     
    int _player_width;
    int _player_height;
    int _objects_size;
    int _speed;
    int lose;
    int _lives;
    int l; //counter for loop
    int n; //counter for loop
    int m; //counter for loop
    
    float _time;

    Direction _d;
    float _mag;
    
    int _kit_size;
    bool collect;
    bool used;
};

#endif