/**
* ELEC2645 Embedded Systems Project
* School of Electronic & Electrical Engineering
* University of Leeds
* @file main.cpp
* @brief 
* @author   Oliver Luong
* Username: ll16o2l
* Student ID Number:201140613
* @Date 05/03/2019
*/

///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "DodgeEngine.h"
#include "Instruction.h"

#define PLAYER_WIDTH 14
#define PLAYER_HEIGHT 14
#define OBJECTS_SIZE 2 
#define OBJECTS_SPEED 4 /////////////////Want to make it changing
#define LIVES 5
#define KIT_SIZE 7

/////////////// structs /////////////////
struct UserInput {
    Direction d; 
    float mag;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
DodgeEngine dodge;
Instruction instruction;
Direction d;

///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
void instructions();

///////////// functions ////////////////
int main()
{
    // This is used for how many loops per second (i.e frames per second)
    int fps = 15;

    init();     // initialise and then display welcome screen
    welcome();  // waiting for the user to start
    instructions(); // waiting for the user to start
    
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period
    
    // This will set the initial value to be used in the loop
    int lose = 0; 
    // This sets the time to 0 until the game starts
    float time = 0;
    
    // game loop - read input, update the game state and render the display
    while (lose == 0) { // Until the value of lose changes to 1 keep looping 
        dodge.read_input(pad); // Execute the read_input method from dodge source file
        dodge.update(pad); // Execute the update method from dodge source file
        render(); // Execute the render method
        wait(1.0f/fps); // This controls how fast the while loop iterates
        time = time + 0.06666f; // Adds the time for every iteration to count the time
//      printf("Time = %.2f \n", time); // Used to test the time is working
        dodge.time(time); // Input the time from the main file to dodge source file
        lose = dodge.get_lose();  // Execute the get_lose method then save return value to time variable
        // printf("Lose = %2d" ,lose);
    }
    main(); // Execute the main method after lose = 1 and the while loop stops
    wait(1.0f);
}/**
* This method will be used to initialies all classes and libraries.
* @author Oliver Luong
* @date 22/04/2019
*/
void init()
{
    // initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game with pre-determerined directives
    dodge.init(PLAYER_WIDTH,PLAYER_HEIGHT,OBJECTS_SIZE,OBJECTS_SPEED,LIVES,KIT_SIZE);

}

/**
* This method will be used to draw the frames onto the LCD.
* @author Oliver Luong
* @date 22/04/2019
*/
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    dodge.draw(lcd);
    lcd.refresh();
}
/**
* This method will be used to initialies the 
* welcome screen and wait for user input.
* @author Oliver Luong
* @date 22/04/2019
*/
void welcome() {
    
    // Write onto the LCD and refresh
    lcd.printString("     Dodge!    ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void instructions() {
    instruction.init();
    while (pad.check_event(Gamepad::A_PRESSED) == false) {
        instruction.write(lcd);
        instruction.control(pad);
    }
}