#ifndef Health_Kit_H
#define Health_Kit_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Health_Kit.h"

/** Health_Kit Class

@brief Controls the functionality of the Dodge game .
@brief Generates the health kit in the Dodge game

@brief Revisions 1.0


@author Oliver Luong, University of Leeds
@date 22/04/2019
*/ 

class Health_Kit
{

public:
    /** Contructor / Destructor */
    Health_Kit();
    ~Health_Kit();

// Methods
    /**
    This method will be used to initialise the health_kit variables.
    Saves global variables to local variables.
    @param kit_size
    */
    void init(int kit_size);
    
    /**
    This method will be used to store the sprite for health_kit and draw it
    onto the LCD.
    */
    void draw(N5110 &lcd); 
    
    /**
    This method will be used to return the postion of the health_kit when called.
    */
    Vector2D get_pos();
    
private:
    
// Variables
    int _kit_size;
    float _x;
    float _y;
    int _x_edge;
    int _y_edge;
};
#endif