#include "DodgeEngine.h"

DodgeEngine::DodgeEngine()
{

}

DodgeEngine::~DodgeEngine()
{

}

void DodgeEngine::init(int player_width,int player_height,int objects_size,int speed, int lives, int kit_size)
{
    _player_width = player_width; // Saving to local variables
    _player_height = player_height;
    _objects_size = objects_size;
    _speed = speed;
    _lives = lives;
    lose = 0;
    _kit_size = kit_size;
    
    _player.init(_player_height,_player_width);
    _objects1.init(_objects_size,_speed);  // Implements multiple objects
    _objects2.init(_objects_size,_speed);
    _objects3.init(_objects_size,_speed);
    _objects4.init(_objects_size,_speed); 
    
    _health_kit.init(_kit_size);
    collect = false; // Setting the initial value to false at every restart
}

void DodgeEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}

void DodgeEngine::draw(N5110 &lcd)
{   
    // draw the elements in the LCD buffer
    // Borders
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    // Score
    print_lives_time(lcd);
    // Player
    _player.draw(lcd);
    // Objects
    _objects1.draw(lcd);
    // At predetermined times, draw the extra objects into the game.
    if (_time > 10) {
        _objects2.draw(lcd);
    }
    if (_time > 20) {
        _objects3.draw(lcd);
    }
    if (_time > 30) {
        _objects4.draw(lcd);
    }
    
    if (_time > 15 && _time <22) {
        if(collect == false) {     // seperated if conditions so the program does not check if collect is false when time does not meet condition
            _health_kit.draw(lcd);   
        } 
    }
}

void DodgeEngine::update(Gamepad &pad)
{
    _player.update(_d, _mag);
    _objects1.update();
    _objects2.update();
    _objects3.update();
    _objects4.update();

    check_wall_collision1(pad); 
    // More effiecient use of processing time if the objects do not 
    // need to be checked for collisions
    if (_time > 10){
        check_wall_collision2(pad);
    }
    if (_time > 20) { 
        check_wall_collision3(pad);
    }
    if (_time > 30) {
        check_wall_collision4(pad);
    }
    
    check_player_collisions1(pad);
    if (_time > 10){
        check_player_collisions2(pad);
    }
    if (_time > 20) { 
        check_player_collisions3(pad);
    }
    if (_time > 30) {
        check_player_collisions4(pad);
    }
    
    // Setting the time for when the health kit is available 
    if (_time > 15 && _time <22) {
        // Seperated if conditions so the program does not check if collect
        // is false when time does not meet condition
        if(collect == false) {     
            check_player_health_kit_collison(pad);   
        } 
    }
    life_up(pad);
    life_leds(pad);
}


void DodgeEngine::check_wall_collision1(Gamepad &pad)
{
    // read current obejects attributes
    Vector2D objects_pos1 = _objects1.get_pos();
    Vector2D objects_velocity1 = _objects1.get_velocity();

    // check if hit top wall
    if (objects_pos1.y + _objects_size >= (HEIGHT-1) ) {
        objects_pos1.y = (HEIGHT-1) - _objects_size;
        objects_velocity1.y = -objects_velocity1.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit bottom wall
    else if (objects_pos1.y <= 1) {
        objects_pos1.y = 0;
        objects_velocity1.y = -objects_velocity1.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit the left side wall
    else if (objects_pos1.x <= 1) {
        objects_pos1.x = 1;
        objects_velocity1.x = -objects_velocity1.x;
        // audio feeback
        pad.tone(999.9,0.05);    
    }
    // check if hit the right side wall
    else if (objects_pos1.x + _objects_size >= (WIDTH-1)) {
        objects_pos1.x = (WIDTH-1) - _objects_size;
        objects_velocity1.x = -objects_velocity1.x;
        // audio feeback
        pad.tone(999.9,0.05);    
    }

    // update objects parameters
    _objects1.set_velocity(objects_velocity1);
    _objects1.set_pos(objects_pos1);
}

void DodgeEngine::check_wall_collision2(Gamepad &pad)
{
    // read current obejects attributes
    Vector2D objects_pos2 = _objects2.get_pos();
    Vector2D objects_velocity2 = _objects2.get_velocity();

    // check if hit top wall
    if (objects_pos2.y + _objects_size >= (HEIGHT-1) ) {
        // hit bottom
        objects_pos2.y = (HEIGHT-1) - _objects_size;
        objects_velocity2.y = -objects_velocity2.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit bottom wall
    else if (objects_pos2.y <= 1) {
        objects_pos2.y = 0;
        objects_velocity2.y = -objects_velocity2.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit the left side wall
    else if (objects_pos2.x <= 1) {
        objects_pos2.x = 1;
        objects_velocity2.x = -objects_velocity2.x;
        // audio feeback
        pad.tone(999.9,0.05);    
    }
    // check if hit the right side wall
    else if (objects_pos2.x + _objects_size >= (WIDTH-1)) {
        objects_pos2.x = (WIDTH-1) - _objects_size;
        objects_velocity2.x = -objects_velocity2.x;
        // audio feeback
        pad.tone(7999.9,0.05);    
    }

    // update objects parameters
    _objects2.set_velocity(objects_velocity2);
    _objects2.set_pos(objects_pos2);
}

void DodgeEngine::check_wall_collision3(Gamepad &pad)
{
    // read current obejects attributes
    Vector2D objects_pos3 = _objects3.get_pos();
    Vector2D objects_velocity3 = _objects3.get_velocity();

    // check if hit top wall
    if (objects_pos3.y + _objects_size >= (HEIGHT-1) ) {
        objects_pos3.y = (HEIGHT-1) - _objects_size;
        objects_velocity3.y = -objects_velocity3.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit bottom wall
    else if (objects_pos3.y <= 1) {
        objects_pos3.y = 0;
        objects_velocity3.y = -objects_velocity3.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit the left side wall
    else if (objects_pos3.x <= 1) {
        objects_pos3.x = 1;
        objects_velocity3.x = -objects_velocity3.x;
        // audio feeback
        pad.tone(999.9,0.05);    
    }
    // check if hit the right side wall
    else if (objects_pos3.x + _objects_size >= (WIDTH-1)) {
        objects_pos3.x = (WIDTH-1) - _objects_size;
        objects_velocity3.x = -objects_velocity3.x;
        // audio feeback
        pad.tone(999.9,0.05);    
    }

    // update objects parameters
    _objects3.set_velocity(objects_velocity3);
    _objects3.set_pos(objects_pos3);
}

void DodgeEngine::check_wall_collision4(Gamepad &pad)
{
    // read current obejects attributes
    Vector2D objects_pos4 = _objects4.get_pos();
    Vector2D objects_velocity4 = _objects4.get_velocity();

    // check if hit top wall
    if (objects_pos4.y + _objects_size >= (HEIGHT-1) ) {
        objects_pos4.y = (HEIGHT-1) - _objects_size;
        objects_velocity4.y = -objects_velocity4.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit bottom wall
    else if (objects_pos4.y <= 1) {
        objects_pos4.y = 0;
        objects_velocity4.y = -objects_velocity4.y;
        // audio feedback
        pad.tone(999.9,0.05);
    }
    // check if hit the left side wall
    else if (objects_pos4.x <= 1) {
        objects_pos4.x = 1;
        objects_velocity4.x = -objects_velocity4.x;
        // audio feeback
        pad.tone(999.9,0.05);    
    }
    // check if hit the right side wall
    else if (objects_pos4.x + _objects_size >= (WIDTH-1)) {
        objects_pos4.x = (WIDTH-1) - _objects_size;
        objects_velocity4.x = -objects_velocity4.x;
        // audio feeback
        pad.tone(999.9,0.05);    
    }

    // update objects parameters
    _objects4.set_velocity(objects_velocity4);
    _objects4.set_pos(objects_pos4);
}

void DodgeEngine::check_player_collisions1(Gamepad &pad)
{
    // read current objects attributes
    Vector2D objects_pos1 = _objects1.get_pos();
    Vector2D objects_velocity1 = _objects1.get_velocity();

    // check player
    Vector2D player_pos = _player.get_pos();

    // see if ball has hit the player by checking for overlaps
    if (
        (objects_pos1.y >= player_pos.y) && //top
        (objects_pos1.y <= player_pos.y + _player_height) && //bottom
        (objects_pos1.x >= player_pos.x) && //left
        (objects_pos1.x <= player_pos.x + _player_width)  //right
    ) {
        player_hit(pad); // Go to player_hit member.
    }

    // write new attributes
    _objects1.set_velocity(objects_velocity1);
    _objects1.set_pos(objects_pos1);
}

void DodgeEngine::check_player_collisions2(Gamepad &pad)
{
    // read current objects attributes
    Vector2D objects_pos2 = _objects2.get_pos();
    Vector2D objects_velocity2 = _objects2.get_velocity();

    // check player
    Vector2D player_pos = _player.get_pos();

    // see if ball has hit the player by checking for overlaps
    if (
        (objects_pos2.y >= player_pos.y) && //top
        (objects_pos2.y <= player_pos.y + _player_height) && //bottom
        (objects_pos2.x >= player_pos.x) && //left
        (objects_pos2.x <= player_pos.x + _player_width)  //right
    ) {
        player_hit(pad);
    }

    // write new attributes
    _objects2.set_velocity(objects_velocity2);
    _objects2.set_pos(objects_pos2);
}

void DodgeEngine::check_player_collisions3(Gamepad &pad)
{
    // read current objects attributes
    Vector2D objects_pos3 = _objects3.get_pos();
    Vector2D objects_velocity3 = _objects3.get_velocity();

    // check player
    Vector2D player_pos = _player.get_pos();

    // see if ball has hit the player by checking for overlaps
    if (
        (objects_pos3.y >= player_pos.y) && //top
        (objects_pos3.y <= player_pos.y + _player_height) && //bottom
        (objects_pos3.x >= player_pos.x) && //left
        (objects_pos3.x <= player_pos.x + _player_width)  //right
    ) {
        player_hit(pad);
    }

    // write new attributes
    _objects3.set_velocity(objects_velocity3);
    _objects3.set_pos(objects_pos3);
}

void DodgeEngine::check_player_collisions4(Gamepad &pad)
{
    // read current objects attributes
    Vector2D objects_pos4 = _objects4.get_pos();
    Vector2D objects_velocity4 = _objects4.get_velocity();

    // check player
    Vector2D player_pos = _player.get_pos();

    // see if ball has hit the player by checking for overlaps
    if (
        (objects_pos4.y >= player_pos.y) && //top
        (objects_pos4.y <= player_pos.y + _player_height) && //bottom
        (objects_pos4.x >= player_pos.x) && //left
        (objects_pos4.x <= player_pos.x + _player_width)  //right
    ) {
        player_hit(pad);
    }

    // write new attributes
    _objects4.set_velocity(objects_velocity4);
    _objects4.set_pos(objects_pos4);
}

void DodgeEngine::check_player_health_kit_collison(Gamepad &pad)
{
    // read current objects attributes
    Vector2D health_kit_pos = _health_kit.get_pos();

    // check player
    Vector2D player_pos = _player.get_pos();

    // see if ball has hit the player by checking for overlaps
    if (
        (health_kit_pos.y >= player_pos.y) && //top
        (health_kit_pos.y <= player_pos.y + _player_height) && //bottom
        (health_kit_pos.x >= player_pos.x) && //left
        (health_kit_pos.x <= player_pos.x + _player_width)  //right
    ) {
        collect = true; // To delcare the player has obtained the health kit.
        used = false; // As the player input is needed in order to use health kit.
    }
}

void DodgeEngine::player_hit(Gamepad &pad)
{
    // Flashes LEDs and makes a noise when the player_hit member is called.
    pad.tone(500.0,0.5);
    pad.tone(250.0,0.5);
    pad.tone(100.0,0.5);
    pad.leds_on(); // Turns on all LEDs
    wait(0.5);
    pad.leds_off();
    _lives = _lives - 1; // Reducing one of the player's lives.
    if (_lives < 1){ // To check that the player still has lives left.
        lose = 1; 
        wait(1.0f);
    }
}

void DodgeEngine::life_leds(Gamepad &pad)
{
    // 6 being the maximum lives that the player can have.
    // Starts from the number of lives and goes to 0 turning on
    // the LEDs accordingly
    n = 6 - _lives;  
    l = _lives;
    while (l>0){
        pad.led(l, 1); // pad.led(LED number, state 1 is on)
        l = l - 1;
    }
    
    // Used in order to turn the LEDs off when lives have been lost
    while (n>0) {
        m = n + _lives;
        pad.led(m, 0); // pad.led(LED number, state 0 is off)
        n = n - 1;    
    }
}

void DodgeEngine::life_up(Gamepad &pad)
{
    if (collect == true & used == false){ // Two conditions need to be met
        if (pad.check_event(Gamepad::A_PRESSED) == true){
            //printf("Lives before extra life = %2d" ,_lives);
            _lives = _lives + 1;
            //printf("Lives after added = %2d" ,_lives);
            used = true; // Set used to true so life up and only be used once.
        }   
    }
}

void DodgeEngine::time(float time)
{
    _time = time;
}

void DodgeEngine::print_lives_time(N5110 &lcd)
{
    printf("Time = %.2f \n",_time);

    // print to LCD i
    char buffer1[14];
    char buffer2[14];
    //printf("Lives = %2d " ,_lives);
    //printf("Time = %2d", _time);
    sprintf(buffer1,"Lives = %2d",_lives);
    sprintf(buffer2,"Time = %.2f",_time);
    lcd.printString(buffer1,5,1);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
    lcd.printString(buffer2,5,4);
    
    if (collect == true & used == false){ // Two conditions need to be met
        lcd.printString("Press A",5,3); // Message for instruction on how to use health kit
    }
}

int DodgeEngine::get_lose(){
    return lose;
}