#ifndef MISSILES_H
#define MISSILES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Missiles class

@brief Class for Missiles

@version 1.0

@author Henri Rigby

@date May 2019

@code

#include "Missiles.h"

Missiles::Missiles()
{

}

Missiles::~Missiles()
{

}

void Missiles::init(int size)
{
    _speed = 3;  // sets initial speed of missile to 3
    _size = size;
    srand(time(NULL));
    int N = rand() % 4;  //randomises a value of N between 0 and 3
    if (N == 0) {
        _y = HEIGHT;  //sets _y value to bottom of lcd display
        _x = rand() % 80 +4;  //randomises _x value
        south();  //calls south function
    } else if (N == 1){
               _y = 0;  //sets _y value to top of lcd display
               _x = rand() % 80 +4;
               north(); //calls north function
    } else if (N == 2){
               _y = rand() % 44 +4;  //randomises _y value
               _x = 0;  //sets _x value to left side of lcd display
               west();  //calls west function
     } else {
            _y = rand() % 44 +4;
            _x = WIDTH;  //sets _x value to right side of lcd display
            east();  //calls east function
    }
}

void Missiles::south()
{
    srand(time(NULL));
    int direction = rand() % 2; //randomises value for direction between 0-1
        if (direction == 0) {
                  _velocity.x = ((2*_speed)^1/2)/2;  //sets x velocity equation means that no strafing will occur
                  _velocity.y = -((2*_speed)^1/2)/2;  //sets y velocity
        } else {
                  _velocity.x = -((2*_speed)^1/2)/2;
                  _velocity.y = -((2*_speed)^1/2)/2;
        }
}

void Missiles::north()
{
           srand(time(NULL));
           int direction = rand() % 2;
            if (direction == 0) {
                       _velocity.x = ((2*_speed)^1/2)/2;
                       _velocity.y = ((2*_speed)^1/2)/2;
            } else {
                    _velocity.x = -((2*_speed)^1/2)/2;
                    _velocity.y = ((2*_speed)^1/2)/2;
            }
}

void Missiles::west()
{
           srand(time(NULL));
           int direction = rand() % 2;
           if (direction == 0) {
                       _velocity.x = ((2*_speed)^1/2)/2;
                       _velocity.y = ((2*_speed)^1/2)/2;
           } else {
                  _velocity.x = ((2*_speed)^1/2)/2;
                  _velocity.y = -((2*_speed)^1/2)/2;
           }
}

void Missiles::east()
{
        int direction = rand() % 2;
        if (direction == 0) {
                   _velocity.x = -((2*_speed)^1/2)/2;
                   _velocity.y = ((2*_speed)^1/2)/2;
        } else {
               _velocity.x = -((2*_speed)^1/2)/2;
               _velocity.y = -((2*_speed)^1/2)/2;
        }
}

void Missiles::update()
{
    _x += _velocity.x;  //sets _x by adding velocity in x direction
    _y += _velocity.y;  //sets _y by adding velocity in y direction
}

void Missiles::draw(N5110 &lcd)
{
    lcd.drawRect(_x,_y,_size,_size,FILL_BLACK);  //draws square representing missile
}

void Missiles::set_velocity(Vector2D v)
{
    _velocity.x = v.x;  //sets the velocity in the x direction
    _velocity.y = v.y;  //sets the velocity in the y direction
}

Vector2D Missiles::get_velocity()
{
    Vector2D v = {_velocity.x,_velocity.y};  //sets 2D velocity
    return v;
}

Vector2D Missiles::get_pos()
{
    Vector2D p = {_x,_y};  //gets the position by taking both _x and _y coordinates
    return p;
}

void Missiles::set_pos(Vector2D p)
{
    _x = p.x;  //sets _x by taking the x component of position
    _y = p.y;  //sets _y by taking the y component of position
}

int Missiles::set_score()
{
    _score = 0;  //sets the value of _score to equal 0
    return _score;
}

void Missiles::add_score()
{
    _score++;  //increases the value of score by 1
}

int Missiles::get_score()
{
    return _score;  //returns the value of _score
}

*/

class Missiles
{

public:
    /**constructor*/
    Missiles();
    /**destructor*/
    ~Missiles();
    /** 
    * @brief Randomises missile starting position
    * @param sets position @details Sets starting position of the missile
    */
    void init(int size);
    /** 
    * @brief Randomises starting direction & velocity if missile starts at bottom
    * @param sets direction & velocity @details Sets starting direction & velocity of missile from bottom
    */
    void south();
    /** 
    * @brief Randomises starting direction & velocity if missile starts at top
    * @param sets direction & velocity @details Sets starting direction & velocity of missile from top
    */
    void north();
    /** 
    * @brief Randomises starting direction & velocity if missile starts on left side
    * @param sets direction & velocity @details Sets starting direction & velocity of missile from left side
    */
    void west();
    /** 
    * @brief Randomises starting direction & velocity if missile starts on right side
    * @param sets direction & velocity @details Sets starting direction & velocity of missile from right side 
    */
    void east();
    /** 
    * @brief Draws the missile
    * @return draws missile @details draws 2x2 square representing a missile
    */
    void draw(N5110 &lcd);
    /** 
    * @brief Updates the position of the missile
    * @param sets position @details Will reset the position of missile by adding the missiles velocity
    */
    void update();
    /** 
    * @brief Sets the score
    * @param sets value of the score(int) @details Sets the score of the game back to 0
    */
    int set_score();
    /** 
    * @brief Increases the score
    * @param sets value of the score @details Increases the value of score by 1
    */
    void add_score();
    /** 
    * @brief Gets the score
    * @return the current score @details Returns the value of what score is currently
    */
    int get_score();
    /** 
    * @brief Sets the velocity
    * @param sets velocity componets @details sets the velocity by equalling it to 2D velocity multiplied by direction
    */
    void set_velocity(Vector2D v);
    /** 
    * @brief Gets the velocity
    * @return 2D velocity @details returns the 2D velocity by taking velocity components of both x and y
    */
    Vector2D get_velocity();
    /** 
    * @brief Gets the position
    * @return position @details returns the position of both the x and y coordinates
    */
    Vector2D get_pos();
    /** 
    * @brief sets the position
    * @param sets position @details sets x and y coordinates by taking their respective values from p
    */
    void set_pos(Vector2D p);
    
private:

    int _x;
    int _y;
    int _score;
    int _speed;
    Vector2D _velocity;
    int _size;
};
#endif