/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Henri Rigby
Username: el17hr
Student ID Number: 201198821
Date: 09/05/2019
*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SpaceRebEngine.h"

#define SPACEINVADER_WIDTH 8
#define SPACEINVADER_HEIGHT 11
#define MISSILES_SIZE 2
#define MISSILES_SPEED 3

struct UserInput {
    Direction d;
    float mag;
};

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
SpaceRebEngine spacerebellion;


    void init();  
    void update_game(UserInput input);
    void render();
    void welcome();
    void menu();
    void Story();
    void Controls();
    void Credits();
    void Game1Over();
    void x1_1();
    void x1_2();
    void x2_1();
    void x2_2();
    void x3_1();
    void x3_2();

bool end = false;
int score = 0;
int speed = MISSILES_SPEED;
int i=0;
int choose = 0;
int X_1[11][11] =   {
    { 1,1,0,0,0,0,0,0,0,0,0 },
    { 1,1,1,0,0,0,0,0,0,0,0 },
    { 0,1,1,1,0,0,0,0,0,0,0 },
    { 0,0,1,1,1,0,0,0,0,0,0 },
    { 0,0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,0,1,1,1,0,0,0,0 },
    { 0,0,0,0,0,1,1,1,0,0,0 },
    { 0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,0,0,1,1,1,0 },
    { 0,0,0,0,0,0,0,0,1,1,1 },
    { 0,0,0,0,0,0,0,0,0,1,1 },
    };
int X_2[11][11] =   {
    { 1,1,0,0,0,0,0,0,0,1,1 },
    { 1,1,1,0,0,0,0,0,1,1,1 },
    { 0,1,1,1,0,0,0,1,1,1,0 },
    { 0,0,1,1,1,0,1,1,1,0,0 },
    { 0,0,0,1,1,1,1,1,0,0,0 },
    { 0,0,0,0,1,1,1,0,0,0,0 },
    { 0,0,0,1,1,1,1,1,0,0,0 },
    { 0,0,1,1,1,0,1,1,1,0,0 },
    { 0,1,1,1,0,0,0,1,1,1,0 },
    { 1,1,1,0,0,0,0,0,1,1,1 },
    { 1,1,0,0,0,0,0,0,0,1,1 },
    };
int invader[8][11] =   {
    { 0,0,1,0,0,0,0,0,1,0,0 },
    { 0,0,0,1,0,0,0,1,0,0,0 },
    { 0,0,1,1,1,1,1,1,1,0,0 },
    { 0,1,1,0,1,1,1,0,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 1,0,1,1,1,1,1,1,1,0,1 },
    { 1,0,1,0,0,0,0,0,1,0,1 },
    { 0,0,0,1,1,0,1,1,0,0,0 },
};
int arrowd[6][11] =  {
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 0,1,1,1,1,1,1,1,1,1,0 },
    { 0,0,1,1,1,1,1,1,1,0,0 },
    { 0,0,0,1,1,1,1,1,0,0,0 },
    { 0,0,0,0,1,1,1,0,0,0,0 },
    { 0,0,0,0,0,1,0,0,0,0,0 },
};

int main()
{
    int fps = 8;  // frames per second
    
    init();     // initialises the lcd, pad and SpaceRebEngine
    welcome();  // opening screen displaying game name
    
    menu:
    menu();  //menu to decide whether player wants to enter story, play, controls or credits
    init();  //will reinitialise when play option is chosen so that screen does not skip to game1over() function
    end = false;  //set the value of end to equal false so game can be re_run multople times
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // waits for one frame period

    while (!end) {  //this means game will play until boolean of end is inverted, equals true
        spacerebellion.read_input(pad);  //takes the input from the joystick
        spacerebellion.update(pad);  //runs the game mechanics 
        render();
        end = spacerebellion.game_end();  //when player dies game will end as valu of end will be true
        wait(1.0f/fps);
    }
    lcd.clear();
    i = 0;
    while(i < 200) {  //creates internal loop that displays animation until i = 200
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_BLACK);  //pitch black screen
    lcd.refresh();
    i++;  //increases integer i by 1
    }
    lcd.clear();
    i = 0;
    while(i < 200) { 
    x1_1();  //draws first half of first x
    lcd.refresh();
    pad.tone(1200.0,0.2);  //plays low beep
    i++;
    }
    i = 0;
    while(i < 200) { 
    x1_2();  //draws first x
    lcd.refresh();
    pad.tone(1500.0,0.2);  //plays high beep
    i++;
    }
    i = 0;
    while(i < 200) { 
    x2_1();  //draws first half of second x
    lcd.refresh();
    pad.tone(1200.0,0.2);
    i++;
    }
    i = 0;
    while(i < 200) { 
    x2_2();  //draws second x
    lcd.refresh();
    pad.tone(1500.0,0.2);
    i++;
    }
    i = 0;
    while(i < 200) { 
    x3_1();  //draws first half of third x
    lcd.refresh();
    pad.tone(1200.0,0.2);
    i++;
    }
    i = 0;
    while(i < 200) { 
    x3_2();  //draws third x
    lcd.refresh();
    pad.tone(1500.0,0.2);
    i++;
    }
    lcd.clear();
    Game1Over();  //displays the game over sequance
    goto menu;  //loops code back to the menu function
}


void init()
{

    lcd.init();  //initialises lcd display
    pad.init();  //initialises gamepad
    //initialises spaceinvader and missiles
    spacerebellion.init(SPACEINVADER_WIDTH,SPACEINVADER_HEIGHT,MISSILES_SIZE,MISSILES_SPEED);

}


void render()
{
    lcd.clear();  
    spacerebellion.draw(lcd);  //draws game
    lcd.refresh();
}

void welcome() {  //startup screen
    
    lcd.printString("     Space    ",0,1);
    lcd.printString("   Rebellion! ",0,2);
    lcd.printString(" Press Start...",0,4);
    lcd.drawSprite(8,3,8,11,(int *)invader); //adds spaceinvader into top left corner
    lcd.drawSprite(WIDTH - 16,3,8,11,(int *)invader); //adds spaceinvader into top right corner
    lcd.refresh();
     
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.15);
        pad.leds_off();
        wait(0.15);  //flashes leds on and of until start is pressed
    }
    lcd.clear();  
    lcd.refresh();
}

void menu() {  //menu screen
    lcd.clear();
    lcd.printString("     MENU    ",0,0);
    lcd.printString("A ==> Story ",0,1);
    lcd.printString("B ==> Play ",0,2);
    lcd.printString("X ==> Controls ",0,3);
    lcd.printString("Y ==> Credits ",0,4);
    lcd.refresh();
    choose = 0;
    // wait flashing LEDs until start button is pressed 
    while (choose == 0) {
        if (pad.check_event(Gamepad::A_PRESSED) == true) {
            choose = 1;  //used to break menu while loop
            Story();  //displays story
            menu();  //returns to menu screen
        } else if (pad.check_event(Gamepad::B_PRESSED) == true) {
            choose = 1;
        } else if (pad.check_event(Gamepad::X_PRESSED) == true) {
            choose = 1;
            Controls();  //displays controls
            menu();
        } else if (pad.check_event(Gamepad::Y_PRESSED) == true) {
            choose = 1;
            Credits();  //displays credits
            menu();
        }
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}


void Story() {
    lcd.clear();
    lcd.printString("    Story    ",0,0);
    lcd.printString("The Year: 2098",0,1);
    lcd.printString("Humans Control",0,2);
    lcd.printString("Sectors 3-8 Of",0,3);
    lcd.printString("The Milky Way.",0,4);
    lcd.printString("    Press A    ",0,5);
    lcd.drawSprite(WIDTH - 12,HEIGHT - 7,6,11,(int *)arrowd);  //adds arrow in bottom right corner
    lcd.drawSprite(1,HEIGHT - 7,6,11,(int *)arrowd);  //adds arrow in bottom left corner
    lcd.refresh();
    int story = 0;  //used to give story value of zero for while loops
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
        if (pad.check_event(Gamepad::A_PRESSED) == true) {
        lcd.clear();
        lcd.printString("    Story    ",0,0);
        lcd.printString("You, The Last ",0,1);
        lcd.printString("Of The Zonians",0,2);
        lcd.printString(" Are Captured ",0,3);
        lcd.printString("Used for Sport",0,4);
        lcd.printString("    Press A   ",0,5);
        lcd.drawSprite(WIDTH - 12,HEIGHT - 7,6,11,(int *)arrowd);  //adds arrow in bottom right corner
        lcd.drawSprite(1,HEIGHT - 7,6,11,(int *)arrowd);   //adds arrow in bottom left corner
        lcd.refresh();
        story = 1; //sets story to equal 1 to enter next while loop when a is pressed
        while (story == 1) {
        if (pad.check_event(Gamepad::A_PRESSED) == true) {
            story = 2;  //if a is pressed awe go to page 3 of story
        }
        }
        while (story == 2){
        lcd.clear();
        lcd.printString("    Story    ",0,0);
        lcd.printString("They Name you ",0,1);
        lcd.printString("'Spaceinvader'",0,2);
        lcd.printString(" This Is Your ",0,3);
        lcd.printString("Colosseum,RUN!",0,4);
        lcd.printString("**Press Back**",0,5);
        lcd.refresh();
        if ( pad.check_event(Gamepad::BACK_PRESSED) == true){
            break;  //breaks while loop when back is pressed in third page of story
            
            }
    }
    break; //goes back to menu screen
    }
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}

void Controls() {
    
    lcd.clear();
    lcd.printString("   Controls    ",0,0);
    lcd.printString("     Aim: ",0,1);
    lcd.printString("!!!!!!!!!!!!!!",0,2);
    lcd.printString("AVOID THE BOMB",0,3);
    lcd.printString("!!!!!!!!!!!!!!",0,4);
    lcd.printString("    Press X",0,5);
    lcd.drawSprite(WIDTH - 12,HEIGHT - 7,6,11,(int *)arrowd);
    lcd.drawSprite(1,HEIGHT - 7,6,11,(int *)arrowd);
    lcd.refresh();
    // wait flashing LEDs until start button is pressed
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {  //if back is pressed we will return to menu screen
    if (pad.check_event(Gamepad::X_PRESSED) == true) {  //if x is pressed then the next page of controls will be displayed
    lcd.clear();
    lcd.printString("   Controls    ",0,0);
    lcd.printString("     How: ",0,1);
    lcd.printString(" Use Joystick ",0,2);
    lcd.printString("To Move Around",0,3);
    lcd.printString("  The Screen  ",0,4);
    lcd.printString("**Press Back**",0,5);
    lcd.refresh();
    }

        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}

void Credits() {
    lcd.clear();
    lcd.printString("   Credits    ",0,0);
    lcd.printString("By Henri Rigby    ",0,3);
    lcd.printString("SID: 201198821    ",0,2);
    lcd.printString("**Press Back**    ",0,5);
    lcd.refresh();
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {  //if back is pressed then will return to main menu after 'easter egg' loop
    // easter egg is lights will flash my surname RIGBY in morse code accompanied by beeps
        wait(1);
        pad.leds_on();
        pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.3);
        pad.leds_on();
        pad.tone(1200.0,0.4);
        wait(0.4);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.6);
        
         pad.leds_on();
         pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.6);
        
        pad.leds_on();
        pad.tone(1200.0,0.4);
        wait(0.4);
        pad.leds_off();
        wait(0.3);
        pad.leds_on();
        pad.tone(1200.0,0.4);
        wait(0.4);
        pad.leds_off();
        wait(0.3);
        pad.leds_on();
        pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.6);
        
        pad.leds_on();
        pad.tone(1200.0,0.4);
        wait(0.4);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.6);
        
         pad.leds_on();
         pad.tone(1200.0,0.4);
        wait(0.4);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1500.0,0.1);
        wait(0.1);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1200.0,0.4);
        wait(0.4);
        pad.leds_off();
        wait(0.3);
         pad.leds_on();
         pad.tone(1200.0,0.4);
        wait(0.4);
        pad.leds_off();
        
    }
 
}

void Game1Over() {
    lcd.printString("   You Died!    ",0,1);
    lcd.printString("  Score =",0,2);
    spacerebellion.print_scores(lcd);  //this is used to print the score after game is played
    lcd.drawSprite(5,3,11,11,(int *)X_2);  //draws an X in top left corner
    lcd.drawSprite(WIDTH - 13,3,11,11,(int *)X_2);  //draws an X in top right corner
    lcd.printString(" Press BACK...",0,4);
    lcd.refresh();
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {  // if back pressed will return to menu
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}

void x1_1() {
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);  //draws rectangle around outline of lcd display
    lcd.drawSprite(WIDTH/2 - 27,HEIGHT/2 - 6,11,11,(int *)X_1);  //draws first half of first x
}

void x1_2() {
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.drawSprite(WIDTH/2 - 27,HEIGHT/2 - 6,11,11,(int *)X_2); //draws first x
}

void x2_1() {
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.drawSprite(WIDTH/2 - 6,HEIGHT/2 - 6,11,11,(int *)X_1);  //draws first half of second x
}

void x2_2() {
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.drawSprite(WIDTH/2 - 6,HEIGHT/2 - 6,11,11,(int *)X_2);  //draws second x
}

void x3_1() {
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.drawSprite(WIDTH/2 + 15,HEIGHT/2 - 6,11,11,(int *)X_1);  //draws first half of third x
}

void x3_2() {
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.drawSprite(WIDTH/2 + 15,HEIGHT/2 - 6,11,11,(int *)X_2);  //draws third x
}