#ifndef SPACEREBENGINE_H
#define SPACEREBENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "SpaceInvader.h"
#include "Missiles.h"

/** SpaceRebEngine class

@brief Class for Space Rebellion Engine

@version 1.0

@author Henri Rigby

@date May 2019

*/

class SpaceRebEngine
{

public:
    /**constructor*/
    SpaceRebEngine();
    /**destructor*/
    ~SpaceRebEngine();
    /** 
    * @brief Initialises spaceinvader and missiles
    * @param sets spaceinvader @details Sets height and width of the spaceinvader private variables
    * @param sets missiles @details Sets size and speed of the missiles private variables
    */
    void init(int spaceinvader_width,int spaceinvader_height,int missiles_size,int speed);
    /** 
    * @brief Sets joystick values
    * @param sets the joystick values @details Sets direction and magnitude of the joystick private variables
    */
    void read_input(Gamepad &pad);
    /** 
    * @brief Updates joystick and missiles values
    * @param sets the joystick values @details Sets direction and magnitude of the joystick private variables
    * @param sets missiles @details Sets size and speed of the missiles private variables
    */
    void update(Gamepad &pad);
    /** 
    * @brief Draws game
    * @return draw game components @details Draws spaceinvader, missiles & play area
    */
    void draw(N5110 &lcd);
    /** 
    * @brief Sets score and prints score
    * @param sets the score value @details Sets the value of _score private variable
    * @return prints value of score @details Prints the score on the lcd display
    */
    void print_scores(N5110 &lcd);
    /** 
    * @brief Sets value of _end
    * @param value of _end @details Returns the boolean value of _end
    */
    void check_spaceinvader_collision(Gamepad &pad);
    /** 
    * @brief Sets missiles velocity
    * @param sets velocity values of missiles @details Sets the values for velocity.x & velocity.y of missiles
    */
    void check_wall_collision(Gamepad &pad);
    /** 
    * @brief Gets value of end
    * @return value of end @details Returns the boolean value of end
    */
    bool game_end();
    
private:
    
    SpaceInvader _player;
     
    int _spaceinvader_width;
    int _spaceinvader_height;
    int _missiles_size;
    int _speed;
    int _score;
    
    bool _end;
    
    Missiles _missiles;
    
    Direction _d;
    float _mag;

};

#endif